/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.maven.deployer.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cocoon.maven.deployer.servlet.ShieldedClassLoader;

public class ShieldedClassLoaderManager {
    public static final String SHIELDED_CLASSLOADER_DEBUG = "shielded-classloader-debug";
    public static final String SHIELDED_CLASSLOADER_USE_REPOSITORY = "shieled-classloader-use-repository";
    public static final String WEB_INF_SHIELDED_LIB = "shielded/lib";
    public static final String WEB_INF_SHIELDED_CLASSES = "shielded/classes";
    protected static final String SHIELDED_LIB = "/WEB-INF/shielded/lib";
    protected static final String SHIELDED_CLASSES = "/WEB-INF/shielded/classes";
    protected static ClassLoader shieldedClassLoader;

    public static synchronized ClassLoader getClassLoader(ServletContext servletContext) throws ServletException {
        if (shieldedClassLoader == null) {
            try {
                shieldedClassLoader = ShieldedClassLoaderManager.createClassLoader(ShieldedClassLoaderManager.class.getClassLoader(), servletContext);
            }
            catch (IOException ioe) {
                throw new ServletException("Unable to create shielded class loader.", (Throwable)ioe);
            }
        }
        return shieldedClassLoader;
    }

    public static void logDebug(ServletContext servletContext, String message) {
        if (servletContext.getInitParameter(SHIELDED_CLASSLOADER_DEBUG) != null && servletContext.getInitParameter(SHIELDED_CLASSLOADER_DEBUG).equalsIgnoreCase("true")) {
            servletContext.log(message);
        }
    }

    protected static ClassLoader createClassLoader(ClassLoader parent, ServletContext servletContext) throws IOException {
        Set resources;
        boolean useShieldedRepository;
        String classesDirectory = SHIELDED_CLASSES;
        String jarDirectory = SHIELDED_LIB;
        if (servletContext.getInitParameter(SHIELDED_CLASSLOADER_USE_REPOSITORY) != null && !(useShieldedRepository = Boolean.valueOf(servletContext.getInitParameter(SHIELDED_CLASSLOADER_USE_REPOSITORY)).booleanValue())) {
            classesDirectory = "/WEB-INF/classes";
            jarDirectory = "/WEB-INF/libs";
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (servletContext.getResource(classesDirectory) != null) {
            urlList.add(servletContext.getResource(classesDirectory));
        }
        if (servletContext.getResource(jarDirectory) != null && (resources = servletContext.getResourcePaths(jarDirectory + '/')) != null) {
            ArrayList<URL> temporaryList = new ArrayList<URL>();
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                if (!path.endsWith(".jar") && !path.endsWith(".zip")) continue;
                temporaryList.add(servletContext.getResource(path));
            }
            Collections.sort(temporaryList, new UrlComparator());
            urlList.addAll(temporaryList);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return new ShieldedClassLoader(urls, parent);
    }

    protected static final class UrlComparator
    implements Comparator {
        protected UrlComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof URL && o2 instanceof URL) {
                return ((URL)o1).toExternalForm().compareTo(((URL)o2).toExternalForm());
            }
            return 0;
        }
    }
}

