/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.cdi;

import javax.cache.Cache;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheRemoveAll;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs.jcache.cdi.CacheKeyInvocationContextImpl;

@CacheRemoveAll
@Interceptor
public class CacheRemoveAllInterceptor {
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CacheDefaults defaults = this.helper.findDefaults(ic);
        CacheRemoveAll cacheRemoveAll = ic.getMethod().getAnnotation(CacheRemoveAll.class);
        String cacheName = this.helper.defaultName(ic.getMethod(), defaults, cacheRemoveAll.cacheName());
        boolean afterInvocation = cacheRemoveAll.afterInvocation();
        CacheKeyInvocationContextImpl<CacheRemoveAll> context = new CacheKeyInvocationContextImpl<CacheRemoveAll>(ic, cacheRemoveAll, cacheName);
        if (!afterInvocation) {
            this.removeAll(context, defaults, cacheRemoveAll);
        }
        try {
            result = ic.proceed();
        }
        catch (Throwable t) {
            if (afterInvocation && this.helper.isIncluded(t.getClass(), cacheRemoveAll.evictFor(), cacheRemoveAll.noEvictFor())) {
                this.removeAll(context, defaults, cacheRemoveAll);
            }
            throw t;
        }
        if (afterInvocation) {
            this.removeAll(context, defaults, cacheRemoveAll);
        }
        return result;
    }

    private void removeAll(CacheKeyInvocationContext<CacheRemoveAll> context, CacheDefaults defaults, CacheRemoveAll cacheRemoveAll) {
        Cache cache = this.helper.cacheResolverFactoryFor(defaults, cacheRemoveAll.cacheResolverFactory()).getCacheResolver(context).resolveCache(context);
        cache.removeAll();
    }
}

