/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.io.File;
import java.io.IOException;
import org.apache.ctakes.core.ae.PausableFileLoggerAE;
import org.apache.ctakes.core.util.external.SystemUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class AbstractCommandRunner
extends PausableFileLoggerAE {
    private static final Logger LOGGER = Logger.getLogger((String)"AbstractCommandRunner");
    public static final String CMD_PARAM = "Command";
    public static final String CMD_DESC = "A full command line to be executed. Make sure to quote.";
    @ConfigurationParameter(name="Command", description="A full command line to be executed. Make sure to quote.", mandatory=false)
    private String _cmd;
    public static final String CMD_DIR_PARAM = "CommandDir";
    public static final String CMD_DIR_DESC = "The Command Executable's directory.";
    @ConfigurationParameter(name="CommandDir", description="The Command Executable's directory.", mandatory=false)
    private String _cmdDir;
    public static final String DIR_PARAM = "WorkingDir";
    public static final String DIR_DESC = "The Working Directory directory.";
    @ConfigurationParameter(name="WorkingDir", description="The Working Directory directory.", mandatory=false)
    private String _workDir;
    public static final String PER_DOC_PARAM = "PerDoc";
    public static final String PER_DOC_DESC = "yes to run the command once per document. Default is no.";
    @ConfigurationParameter(name="PerDoc", description="yes to run the command once per document. Default is no.", defaultValue={"no"}, mandatory=false)
    private String _perDoc;
    public static final String LOG_NAME_PARAM = "Log";
    public static final String LOG_NAME_DESC = "A name for the streaming logger.  Default is the Command.";
    @ConfigurationParameter(name="Log", description="A name for the streaming logger.  Default is the Command.", mandatory=false)
    private String _logName;

    protected boolean isCommandMandatory() {
        return true;
    }

    protected String getCommand() {
        return this._cmd;
    }

    protected String getCommandDir() {
        return this._cmdDir;
    }

    protected String getWorkingDir() {
        return this._workDir;
    }

    @Override
    protected boolean processPerDoc() {
        return this._perDoc.equalsIgnoreCase("yes") || this._perDoc.equalsIgnoreCase("true");
    }

    protected String getLogName() {
        return this._logName;
    }

    protected String getFullCommand() {
        String commandDir = this.getCommandDir();
        String command = this.getCommand();
        return commandDir == null || commandDir.isEmpty() ? command : commandDir + File.separator + command;
    }

    @Override
    public void logInfo(String info) {
        LOGGER.info((Object)info);
    }

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this._cmd = SystemUtil.subVariableParameters(this._cmd, context);
        this._cmdDir = SystemUtil.subVariableParameters(this._cmdDir, context);
        this._workDir = SystemUtil.subVariableParameters(this._workDir, context);
        if (this._cmdDir != null && !this._cmdDir.isEmpty() && !new File(this._cmdDir).exists()) {
            LOGGER.warn((Object)("Cannot find Command Directory " + this._cmdDir));
        }
        if (this._workDir != null && !this._workDir.isEmpty() && !new File(this._workDir).exists()) {
            LOGGER.warn((Object)("Cannot find Working Directory " + this._workDir));
        }
        if (this.isCommandMandatory() && (this._cmd == null || this._cmd.trim().isEmpty())) {
            throw new ResourceInitializationException((Throwable)new IOException("Parameter Command must be set."));
        }
    }
}

