/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="CCDA Sectionizer", description="Annotates Document Sections by detecting Section Headers using Regular Expressions provided in a File.", dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID}, products={PipeBitInfo.TypeProduct.SECTION})
public class CDASegmentAnnotator
extends JCasAnnotator_ImplBase {
    Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected static HashMap<String, Pattern> patterns = new HashMap();
    protected static HashMap<String, String> section_names = new HashMap();
    protected static final String DEFAULT_SECTION_FILE_NAME = "src/user/resources/org/apache/ctakes/core/sections/ccda_sections.txt";
    public static final String PARAM_FIELD_SEPERATOR = ",";
    public static final String PARAM_COMMENT = "#";
    public static final String SIMPLE_SEGMENT = "SIMPLE_SEGMENT";
    public static final String PARAM_SECTIONS_FILE = "sections_file";
    @ConfigurationParameter(name="sections_file", description="Path to File that contains the section header mappings", defaultValue={"src/user/resources/org/apache/ctakes/core/sections/ccda_sections.txt"}, mandatory=false)
    protected String sections_path;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(FileLocator.getAsStream(this.sections_path)));
            this.logger.info((Object)("Reading Section File " + this.sections_path));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith(PARAM_COMMENT)) continue;
                Object[] l = line.split(PARAM_FIELD_SEPERATOR);
                if (l != null && l.length > 0 && l[0] != null && ((String)l[0]).length() > 0 && !line.endsWith(PARAM_FIELD_SEPERATOR)) {
                    String id = ((String)l[0]).trim();
                    Pattern p = CDASegmentAnnotator.buildPattern((String[])l);
                    patterns.put(id, p);
                    if (l.length <= 2 || l[2] == null) continue;
                    String temp = ((String)l[2]).trim();
                    section_names.put(id, temp);
                    continue;
                }
                this.logger.info((Object)("Warning: Skipped reading sections config row: " + Arrays.toString(l)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private static Pattern buildPattern(String[] line) {
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < line.length; ++i) {
            sb.append("\\s*" + line[i].trim() + "(\\s\\s|\\s:|:|\\s-|-)");
            if (i == line.length - 1) continue;
            sb.append("|");
        }
        int patternFlags = 0;
        patternFlags |= 2;
        patternFlags |= 0x20;
        Pattern p = Pattern.compile("^(" + sb + ")", patternFlags |= 8);
        return p;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String text = jCas.getDocumentText();
        if (text == null) {
            String docId = DocIdUtil.getDocumentID(jCas);
            this.logger.info((Object)("text is null for docId=" + docId));
        } else {
            ArrayList<Segment> sorted_segments = new ArrayList<Segment>();
            for (String id : patterns.keySet()) {
                Pattern p = patterns.get(id);
                Matcher m = p.matcher(text);
                while (m.find()) {
                    Segment segment = new Segment(jCas);
                    segment.setBegin(m.start());
                    segment.setEnd(m.end());
                    segment.setId(id);
                    sorted_segments.add(segment);
                }
            }
            if (sorted_segments.size() <= 0) {
                Segment header = new Segment(jCas);
                header.setBegin(0);
                header.setEnd(text.length());
                header.setId(SIMPLE_SEGMENT);
                sorted_segments.add(header);
            }
            Collections.sort(sorted_segments, new Comparator<Segment>(){

                @Override
                public int compare(Segment s1, Segment s2) {
                    return s1.getBegin() - s2.getBegin();
                }
            });
            int index = 0;
            for (Segment s : sorted_segments) {
                Segment segment;
                int prevEnd = s.getEnd();
                int nextBegin = text.length();
                if (index > 0) {
                    ((Segment)sorted_segments.get(index - 1)).getEnd();
                }
                if (index + 1 < sorted_segments.size()) {
                    nextBegin = ((Segment)sorted_segments.get(index + 1)).getBegin();
                }
                if (nextBegin > prevEnd) {
                    segment = new Segment(jCas);
                    segment.setBegin(prevEnd);
                    segment.setEnd(nextBegin);
                    segment.setId(s.getId());
                    segment.addToIndexes();
                    segment.setPreferredText(section_names.get(s.getId()));
                    ++index;
                    continue;
                }
                if (nextBegin != prevEnd || nextBegin <= 0 || index != 0) continue;
                segment = new Segment(jCas);
                segment.setBegin(0);
                segment.setEnd(nextBegin);
                segment.setId(s.getId());
                segment.addToIndexes();
                ++index;
            }
        }
    }
}

