/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.io.IOException;
import org.apache.ctakes.core.ae.AbstractCommandRunner;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.external.SystemUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="CommandRunner", description="Runs an external process.", role=PipeBitInfo.Role.SPECIAL)
public class CommandRunner
extends AbstractCommandRunner {
    private static final Logger LOGGER = Logger.getLogger((String)"CommandRunner");
    public static final String SET_JAVAHOME_PARAM = "SetJavaHome";
    public static final String SET_JAVAHOME_DESC = "Set JAVA_HOME to the Java running cTAKES.  Default is yes.";
    @ConfigurationParameter(name="SetJavaHome", description="Set JAVA_HOME to the Java running cTAKES.  Default is yes.", defaultValue={"yes"}, mandatory=false)
    private String _setJavaHome;

    protected boolean setJavaHome() {
        return this._setJavaHome.equalsIgnoreCase("yes") || this._setJavaHome.equalsIgnoreCase("true");
    }

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        if (this.processPerDoc()) {
            return;
        }
        try {
            this.runCommand();
        }
        catch (IOException ioE) {
            throw new ResourceInitializationException((Throwable)ioE);
        }
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (!this.processPerDoc()) {
            return;
        }
        try {
            this.runCommand();
        }
        catch (IOException ioE) {
            throw new AnalysisEngineProcessException((Throwable)ioE);
        }
    }

    @Override
    protected void runCommand() throws IOException {
        String workingDir;
        String command = this.getFullCommand();
        SystemUtil.CommandRunner runner = new SystemUtil.CommandRunner(command);
        String logFile = this.getLogFile();
        if (logFile != null && !logFile.isEmpty()) {
            runner.setLogFiles(logFile);
        } else {
            Logger logger = this.getRunLogger();
            runner.setLogger(logger);
        }
        runner.wait(this.shouldWait());
        if (!this.setJavaHome()) {
            runner.setSetJavaHome(false);
        }
        if ((workingDir = this.getWorkingDir()) != null && !workingDir.isEmpty()) {
            runner.setDirectory(workingDir);
        }
        LOGGER.info((Object)("Running " + command + " ..."));
        if (logFile != null && !logFile.isEmpty()) {
            LOGGER.info((Object)("Log File is " + logFile));
        }
        SystemUtil.run(runner);
        this.pause();
    }

    private Logger getRunLogger() {
        String logName = this.getLogName();
        if (logName != null && !logName.isEmpty()) {
            return Logger.getLogger((String)logName);
        }
        String command = this.getCommand().trim();
        int spaceIndex = command.indexOf(32);
        if (spaceIndex < 0) {
            return Logger.getLogger((String)command);
        }
        return Logger.getLogger((String)command.substring(0, spaceIndex));
    }

    public static AnalysisEngineDescription createEngineDescription(String command) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(CommandRunner.class, (Object[])new Object[]{"Command", command});
    }
}

