/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.io.File;
import java.io.IOException;
import org.apache.ctakes.core.ae.PausableFileLoggerAE;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.external.SystemUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="CtakesRunner", description="Starts a new instance of cTAKES with the given piper parameters.", role=PipeBitInfo.Role.SPECIAL)
public class CtakesRunner
extends PausableFileLoggerAE {
    private static final Logger LOGGER = Logger.getLogger((String)"CtakesRunner");
    public static final String PIPE_PARAM = "Pipeline";
    public static final String PIPE_DESC = "Piper parameters. Make sure to quote.";
    @ConfigurationParameter(name="Pipeline", description="Piper parameters. Make sure to quote.")
    private String _pipeline;
    private static final String JAVA_CMD = "-Xms512M -Xmx3g org.apache.ctakes.core.pipeline.PiperFileRunner";
    private String _logFile;

    @Override
    protected boolean processPerDoc() {
        return false;
    }

    @Override
    public void logInfo(String info) {
        LOGGER.info((Object)info);
    }

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this._pipeline = SystemUtil.subVariableParameters(this._pipeline, context);
        try {
            this.runCommand();
        }
        catch (IOException ioE) {
            throw new ResourceInitializationException((Throwable)ioE);
        }
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
    }

    @Override
    protected String getLogFile() {
        String logFile = super.getLogFile();
        if (logFile != null && !logFile.isEmpty()) {
            return logFile;
        }
        String piper = "UnknownPiper";
        try {
            piper = this.getPiper();
        }
        catch (IOException ioE) {
            LOGGER.error((Object)ioE.getMessage());
        }
        return this.getLogFile("ctakes_" + piper + ".log");
    }

    private String getPiper() throws IOException {
        int pIndex = this._pipeline.indexOf("-p ");
        if (pIndex < 0) {
            throw new IOException("Improper Piper Runner Specification " + this._pipeline);
        }
        int spaceIndex = this._pipeline.indexOf(32, pIndex + 4);
        if (spaceIndex < 4) {
            throw new IOException("Improper Piper Runner Specification " + this._pipeline);
        }
        String piper = this._pipeline.substring(pIndex + 3, spaceIndex);
        int slashIndex = piper.lastIndexOf(47);
        if (slashIndex < 0) {
            slashIndex = piper.lastIndexOf(92);
        }
        if (slashIndex >= 0) {
            piper = piper.substring(slashIndex + 1);
        }
        if (piper.endsWith(".piper")) {
            piper = piper.substring(0, piper.length() - 6);
        }
        return piper;
    }

    @Override
    protected void runCommand() throws IOException {
        String java_home = System.getProperty("java.home");
        SystemUtil.CommandRunner runner = new SystemUtil.CommandRunner("\"" + java_home + File.separator + "bin" + File.separator + "java\" " + JAVA_CMD + " " + this._pipeline);
        String logFile = this.getLogFile();
        runner.setLogFiles(logFile);
        LOGGER.info((Object)("Starting external cTAKES pipeline with " + this._pipeline + " ..."));
        SystemUtil.run(runner);
        this.pause();
    }

    public static AnalysisEngineDescription createEngineDescription(String pipe) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(CtakesRunner.class, (Object[])new Object[]{PIPE_PARAM, pipe});
    }
}

