/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;

@PipeBitInfo(name="Document ID Printer", description="Logs the Document ID to Log4j and Standard Output.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public class DocumentIdPrinterAnalysisEngine
extends JCasAnnotator_ImplBase {
    protected final Logger logger = Logger.getLogger((String)DocumentIdPrinterAnalysisEngine.class.getName());

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String documentId = DocIdUtil.getDocumentID(jcas);
        String logMessage = String.format("##### current file document id: \"%s\"", documentId);
        this.logger.info((Object)logMessage);
        System.out.println(logMessage);
    }
}

