/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.awt.Frame;
import javax.swing.JOptionPane;
import org.apache.ctakes.core.ae.inert.PausableAE;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="ExitForcer", description="Forcibly Exits cTAKES.  Use only at the end of a pipeline.", role=PipeBitInfo.Role.SPECIAL)
public class ExitForcer
extends PausableAE {
    private static final Logger LOGGER = Logger.getLogger((String)"ExitForcer");
    public static final String FORCE_PARAM = "ForceExit";
    public static final String FORCE_DESC = "Forcibly exits the system when the value is yes.  Yes by default.";
    @ConfigurationParameter(name="ForceExit", description="Forcibly exits the system when the value is yes.  Yes by default.", mandatory=false, defaultValue={"yes"})
    private String _forceExit;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
    }

    @Override
    protected void logInfo(String info) {
        LOGGER.info((Object)info);
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        String force = this._forceExit.toLowerCase();
        if (!force.equals("yes") && !force.equals("true")) {
            return;
        }
        this.pause();
        Frame[] frames = Frame.getFrames();
        if (frames != null && frames.length > 0) {
            JOptionPane.showMessageDialog(null, "Processing Complete.  Click OK to exit.");
        }
        LOGGER.info((Object)"Exiting.");
        System.exit(0);
    }
}

