/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.annotation.OntologyConceptUtil;
import org.apache.ctakes.core.util.textspan.DefaultAspanComparator;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.ResultOfTextRelation;
import org.apache.ctakes.typesystem.type.syntax.NumToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.DateAnnotation;
import org.apache.ctakes.typesystem.type.textsem.FractionAnnotation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.LabMention;
import org.apache.ctakes.typesystem.type.textsem.MeasurementAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.RangeAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="LabValueFinder", description="Associates Lab Mentions with values.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.BASE_TOKEN, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.GENERIC_RELATION})
public final class LabValueFinder
extends JCasAnnotator_ImplBase {
    public static final String PARAM_ALL_SECTIONS = "allSections";
    public static final String PARAM_SECTIONS = "sections";
    public static final String PARAM_VALUE_WORDS = "valueWords";
    public static final String PARAM_MAX_NEWLINES = "maxLineCount";
    public static final int DEFAULT_MAX_LINE_COUNT = 2;
    public static final String PARAM_LAB_TUIS = "labTUIs";
    public static final String PARAM_LAB_X_CUIS = "excludeCUIs";
    public static final String PARAM_USE_DRUGS = "useDrugs";
    private static final String[] REQUIRED_SECTIONS = new String[]{"2.16.840.1.113883.10.20.22.2.3.1"};
    private static final String[] REQUIRED_VALUE_WORDS = new String[]{"positive", "negative", "elevated", "normal", "increased", "decreased"};
    private static final String[] REQUIRED_LAB_TUIS = new String[]{"T059", "T060", "T201"};
    private static final String[] REQUIRED_EXCLUDE_CUIS = new String[]{"C1443182", "C1715372", "C1441604"};
    static final Logger LOGGER = Logger.getLogger((String)"LabValueFinder");
    @ConfigurationParameter(name="allSections", description="Use all Annotatable sections.  This ignores the value of sections", defaultValue={"true"}, mandatory=false)
    private String _useAllSectionText;
    private boolean _useAllSections;
    @ConfigurationParameter(name="sections", description="Annotatable sections", defaultValue={}, mandatory=false)
    private String[] _annotatableSections;
    private Collection<String> annotatableSections;
    @ConfigurationParameter(name="valueWords", description="Words indicating values", defaultValue={}, mandatory=false)
    private String[] _valueWords;
    private Collection<String> valueWords;
    @ConfigurationParameter(name="maxLineCount", description="Maximum newlines between lab and value", mandatory=false)
    private int maxLineCount = 2;
    @ConfigurationParameter(name="labTUIs", description="TUIs indicating lab measurements", defaultValue={})
    private String[] _labTuis;
    private Collection<String> labTuis;
    @ConfigurationParameter(name="excludeCUIs", description="CUIs not indicating specific lab measurements", defaultValue={}, mandatory=false)
    private String[] _excludeCuis;
    private Collection<String> excludeCuis;
    @ConfigurationParameter(name="useDrugs", description="Use Medications in addition to Labs.", defaultValue={"false"}, mandatory=false)
    private String _useDrugsText;
    private boolean _useDrugs;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this._useAllSections = Boolean.parseBoolean(this._useAllSectionText);
        this.annotatableSections = LabValueFinder.gatherParameters(REQUIRED_SECTIONS, this._annotatableSections);
        this.valueWords = LabValueFinder.gatherParameters(REQUIRED_VALUE_WORDS, this._valueWords);
        this.labTuis = LabValueFinder.gatherParameters(REQUIRED_LAB_TUIS, this._labTuis);
        this.excludeCuis = LabValueFinder.gatherParameters(REQUIRED_EXCLUDE_CUIS, this._excludeCuis);
        this._useDrugs = Boolean.parseBoolean(this._useDrugsText);
        LOGGER.debug((Object)("maxLineCount = " + this.maxLineCount));
        LOGGER.info((Object)(this.labTuis.size() + " lab TUIs: " + this.labTuis.toString()));
    }

    private static Collection<String> gatherParameters(String[] requiredValues, String[] userValues) {
        Collection values = Arrays.stream(requiredValues).map(String::toUpperCase).collect(Collectors.toSet());
        for (String value : userValues) {
            values.add(value.toUpperCase());
        }
        return values;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Associating Labs with values ...");
        List<Class<? extends Annotation>> valueClasses = Arrays.asList(NumToken.class, FractionAnnotation.class);
        Map<Annotation, List<IdentifiedAnnotation>> filterMap = LabValueFinder.createCoveringMap(jCas, valueClasses, Arrays.asList(DateAnnotation.class, TimeAnnotation.class));
        Map<Annotation, List<IdentifiedAnnotation>> subsumeMap = LabValueFinder.createCoveringMap(jCas, valueClasses, Arrays.asList(FractionAnnotation.class, RangeAnnotation.class, MeasurementAnnotation.class));
        for (Segment segment : JCasUtil.select((JCas)jCas, Segment.class)) {
            if (!this._useAllSections && !this.annotatableSections.isEmpty() && !this.annotatableSections.contains(segment.getId())) continue;
            List<LabMention> mentions = this.annotateMentions(jCas, segment);
            this.fillInValues(jCas, mentions, filterMap, subsumeMap, segment.getBegin(), segment.getEnd());
        }
        LOGGER.info((Object)"Finished.");
    }

    private List<LabMention> annotateMentions(JCas jCas, Segment segment) {
        ArrayList<LabMention> unvaluedLabMentions = new ArrayList<LabMention>();
        for (IdentifiedAnnotation annotation : JCasUtil.selectCovered((JCas)jCas, IdentifiedAnnotation.class, (AnnotationFS)segment)) {
            Collection validConcepts;
            if (LabMention.class.isInstance(annotation)) {
                ResultOfTextRelation relation = ((LabMention)annotation).getLabValue();
                if (relation != null && relation.getArg2() != null) continue;
                if (relation == null) {
                    LabValueFinder.initValueRelation(jCas, (LabMention)annotation);
                }
                unvaluedLabMentions.add((LabMention)annotation);
                continue;
            }
            if (this._useDrugs && MedicationMention.class.isInstance(annotation)) {
                LOGGER.info((Object)("Using Drug " + annotation.getCoveredText()));
                LabMention lab = LabValueFinder.createLabMention(jCas, OntologyConceptUtil.getUmlsConcepts(annotation), annotation.getBegin(), annotation.getEnd());
                unvaluedLabMentions.add(lab);
            }
            if ((validConcepts = (Collection)OntologyConceptUtil.getUmlsConceptStream(annotation).filter(c -> this.labTuis.contains(c.getTui())).filter(c -> !this.excludeCuis.contains(c.getCui())).collect(Collectors.toList())).isEmpty()) continue;
            LabMention lab = LabValueFinder.createLabMention(jCas, validConcepts, annotation.getBegin(), annotation.getEnd());
            unvaluedLabMentions.add(lab);
        }
        return unvaluedLabMentions;
    }

    private static void initValueRelation(JCas jCas, LabMention lab) {
        ResultOfTextRelation relation = new ResultOfTextRelation(jCas);
        RelationArgument arg1 = new RelationArgument(jCas);
        arg1.setArgument((Annotation)lab);
        relation.setArg1(arg1);
        lab.setLabValue(relation);
    }

    private static LabMention createLabMention(JCas jCas, Collection<UmlsConcept> concepts, int begin, int end) {
        LabMention lab = new LabMention(jCas, begin, end);
        lab.setId(9);
        lab.setDiscoveryTechnique(3);
        FSArray conceptArray = new FSArray(jCas, concepts.size());
        int arrIdx = 0;
        for (UmlsConcept umlsConcept : concepts) {
            conceptArray.set(arrIdx, (FeatureStructure)umlsConcept);
            ++arrIdx;
        }
        lab.setOntologyConceptArr(conceptArray);
        LabValueFinder.initValueRelation(jCas, lab);
        lab.addToIndexes();
        LOGGER.debug((Object)("created " + LabValueFinder.getDebugText((Annotation)lab)));
        return lab;
    }

    private static List<Integer> getNewLines(String docText, int segmentBegin, int segmentEnd) {
        ArrayList<Integer> newLines = new ArrayList<Integer>();
        int index = docText.indexOf(10, segmentBegin);
        while (index >= 0 && index < segmentEnd) {
            newLines.add(index);
            index = docText.indexOf(10, index + 1);
        }
        newLines.add(segmentEnd);
        return newLines;
    }

    private void fillInValues(JCas jCas, List<LabMention> labs, Map<Annotation, List<IdentifiedAnnotation>> filterMap, Map<Annotation, List<IdentifiedAnnotation>> subsumeMap, int segmentBegin, int segmentEnd) {
        if (labs == null || labs.isEmpty()) {
            return;
        }
        List<Integer> newLines = LabValueFinder.getNewLines(jCas.getDocumentText(), segmentBegin, segmentEnd);
        List<LabMention> sortedLabs = LabValueFinder.sortOverlapsByLength(labs);
        int numMentions = sortedLabs.size();
        HashSet<Object> candidateSet = new HashSet<Object>();
        for (int i = 0; i < numMentions; ++i) {
            candidateSet.clear();
            LabMention lab = sortedLabs.get(i);
            Annotation value = null;
            LabMention nextLab = i + 1 < sortedLabs.size() ? sortedLabs.get(i + 1) : null;
            int nextLabBegin = nextLab != null ? nextLab.getBegin() : newLines.get(newLines.size() - 1).intValue();
            int windowBegin = lab.getEnd();
            int windowEnd = this.getValueWindowEnd(windowBegin, nextLabBegin, newLines);
            LOGGER.debug((Object)("Seeking value for: " + LabValueFinder.getDebugText((Annotation)lab) + " between " + windowBegin + " and " + windowEnd));
            for (NumToken numToken : JCasUtil.selectCovered((JCas)jCas, NumToken.class, (int)windowBegin, (int)windowEnd)) {
                LOGGER.debug((Object)("   " + LabValueFinder.getDebugText((Annotation)numToken)));
                List<IdentifiedAnnotation> filters = filterMap.get(numToken);
                if (filters != null && !filters.isEmpty()) {
                    LOGGER.debug((Object)("      Filtering due to " + LabValueFinder.getDebugText((Annotation)filters.get(0))));
                    continue;
                }
                List subsumers = subsumeMap.getOrDefault(numToken, Collections.emptyList());
                if (subsumers.isEmpty()) {
                    candidateSet.add(numToken);
                    continue;
                }
                candidateSet.addAll(subsumers);
                LOGGER.debug((Object)("subsuming candidate: " + LabValueFinder.getDebugText((Annotation)numToken)));
            }
            if (!candidateSet.isEmpty()) {
                ArrayList<Annotation> candidateList = new ArrayList<Annotation>(candidateSet);
                candidateList.sort(DefaultAspanComparator.getInstance());
                value = candidateList.stream().filter(a -> !(a instanceof RangeAnnotation)).findFirst().orElse((Annotation)candidateList.get(0));
                LOGGER.debug((Object)("Set to value: " + LabValueFinder.getDebugText(value)));
            } else {
                value = JCasUtil.selectCovered((JCas)jCas, WordToken.class, (int)windowBegin, (int)windowEnd).stream().filter(w -> this.valueWords.contains(w.getCoveredText().toUpperCase())).findFirst().orElse(null);
            }
            if (value == null) continue;
            LOGGER.debug((Object)("setting lab value to " + LabValueFinder.getDebugText(value)));
            RelationArgument arg2 = new RelationArgument(jCas);
            arg2.setArgument(value);
            lab.getLabValue().setArg2(arg2);
        }
    }

    private int getValueWindowEnd(int windowBegin, int nextLabBegin, List<Integer> newLines) {
        int eolSkips = 0;
        int maxNewLine = newLines.get(newLines.size() - 1);
        for (Integer newLine : newLines) {
            if (newLine < windowBegin) continue;
            if (++eolSkips > this.maxLineCount) break;
            maxNewLine = newLine;
            if (newLine <= nextLabBegin) continue;
            break;
        }
        return Math.min(maxNewLine, nextLabBegin);
    }

    private static Map<Annotation, List<IdentifiedAnnotation>> createCoveringMap(JCas jCas, List<Class<? extends Annotation>> coveredClasses, List<Class<? extends IdentifiedAnnotation>> coveringClasses) {
        HashMap<Annotation, List<IdentifiedAnnotation>> allCovering = new HashMap<Annotation, List<IdentifiedAnnotation>>();
        for (Class<? extends Annotation> covered : coveredClasses) {
            for (Class<? extends IdentifiedAnnotation> covering : coveringClasses) {
                Map map = JCasUtil.indexCovering((JCas)jCas, covered, covering);
                map.forEach((k, v) -> allCovering.computeIfAbsent((Annotation)k, c -> new ArrayList()).addAll(v));
            }
        }
        return allCovering;
    }

    private static <T extends Annotation> List<T> sortOverlapsByLength(List<T> list) {
        ArrayList<T> sortedList = new ArrayList<T>(list);
        sortedList.sort((a1, a2) -> {
            int begin1 = a1.getBegin();
            int end1 = a1.getEnd();
            int begin2 = a2.getBegin();
            int end2 = a2.getEnd();
            int beginCompare = Integer.compare(begin1, begin2);
            return beginCompare < 0 ? Integer.compare(end1, begin2) : (beginCompare == 0 ? Integer.compare(end1, end2) : Integer.compare(begin1, end2));
        });
        return sortedList;
    }

    private static String getDebugText(Annotation a) {
        return a.getType().getShortName() + "(" + a.getBegin() + "-" + a.getEnd() + "): " + a.getCoveredText();
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(LabValueFinder.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription createAnnotatorDescription(Object ... objects) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(LabValueFinder.class, (Object[])objects);
    }
}

