/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.Pair;
import org.apache.ctakes.core.util.regex.RegexSpanFinder;
import org.apache.ctakes.typesystem.type.textspan.ListEntry;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="List Annotator", description="Annotates formatted List Sections by detecting them using Regular Expressions provided in an input File.", dependencies={PipeBitInfo.TypeProduct.SECTION}, products={PipeBitInfo.TypeProduct.LIST})
public final class ListAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"ListAnnotator");
    public static final String LIST_TYPES_PATH = "LIST_TYPES_PATH";
    private static final String LIST_TYPES_DESC = "path to a file containing a list of regular expressions and corresponding list types.";
    private static final String DEFAULT_LIST_ID = "SIMPLE_LIST";
    @ConfigurationParameter(name="LIST_TYPES_PATH", description="path to a file containing a list of regular expressions and corresponding list types.", defaultValue={"org/apache/ctakes/core/list/DefaultListRegex.bsv"})
    private String _listTypesPath;
    private final Collection<ListType> _listTypes = new HashSet<ListType>();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        LOGGER.info((Object)"Initializing ...");
        super.initialize(context);
        if (this._listTypesPath == null) {
            LOGGER.error((Object)"No path to a file containing a list of regular expressions and corresponding list types.");
            return;
        }
        LOGGER.info((Object)("Parsing " + this._listTypesPath));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileLocator.getAsStream(this._listTypesPath)));){
            String line = reader.readLine();
            while (line != null) {
                this.parseBsvLine(line);
                line = reader.readLine();
            }
        }
        catch (IOException ioE) {
            throw new ResourceInitializationException((Throwable)ioE);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Annotating Lists ...");
        if (this._listTypes.isEmpty()) {
            LOGGER.info((Object)"Finished processing, no list types defined");
            return;
        }
        Collection paragraphs = JCasUtil.select((JCas)jcas, Paragraph.class);
        if (paragraphs != null && !paragraphs.isEmpty()) {
            for (Paragraph paragraph : paragraphs) {
                try {
                    Map<Pair<Integer>, ListType> listTypes = this.findListTypes(paragraph.getCoveredText());
                    Map<Pair<Integer>, ListType> uniqueListTypes = ListAnnotator.getUniqueListTypes(listTypes);
                    ListAnnotator.createLists(jcas, uniqueListTypes, paragraph.getCoveredText(), paragraph.getBegin());
                }
                catch (StringIndexOutOfBoundsException listTypes) {}
            }
        } else {
            for (Segment section : JCasUtil.select((JCas)jcas, Segment.class)) {
                Map<Pair<Integer>, ListType> listTypes = this.findListTypes(section.getCoveredText());
                Map<Pair<Integer>, ListType> uniqueListTypes = ListAnnotator.getUniqueListTypes(listTypes);
                ListAnnotator.createLists(jcas, uniqueListTypes, section.getCoveredText(), section.getBegin());
            }
        }
    }

    private Map<Pair<Integer>, ListType> findListTypes(String text) {
        HashMap<Pair<Integer>, ListType> listTypes = new HashMap<Pair<Integer>, ListType>();
        for (ListType listType : this._listTypes) {
            if (listType.__listPattern == null) continue;
            RegexSpanFinder finder = new RegexSpanFinder(listType.__listPattern);
            Throwable throwable = null;
            try {
                List<Pair<Integer>> spans = finder.findSpans(text);
                spans.forEach(s -> listTypes.put((Pair<Integer>)s, listType));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (finder == null) continue;
                if (throwable != null) {
                    try {
                        finder.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                finder.close();
            }
        }
        return listTypes;
    }

    private static Map<Pair<Integer>, ListType> getUniqueListTypes(Map<Pair<Integer>, ListType> listTypes) {
        if (listTypes == null || listTypes.size() <= 1) {
            return listTypes;
        }
        HashSet<Pair<Object>> removalTypeBounds = new HashSet<Pair<Object>>();
        HashMap newTypeBounds = new HashMap();
        while (true) {
            List sortedBounds = listTypes.keySet().stream().sorted((p1, p2) -> (Integer)p2.getValue2() - (Integer)p2.getValue1() - ((Integer)p1.getValue2() - (Integer)p1.getValue1())).collect(Collectors.toList());
            for (int i = 0; i < sortedBounds.size() - 1; ++i) {
                Pair boundsI = (Pair)sortedBounds.get(i);
                for (int j = i + 1; j < sortedBounds.size(); ++j) {
                    Pair boundsJ = (Pair)sortedBounds.get(j);
                    if ((Integer)boundsJ.getValue1() >= (Integer)boundsI.getValue1() && (Integer)boundsJ.getValue1() <= (Integer)boundsI.getValue2()) {
                        removalTypeBounds.add(boundsJ);
                        if ((Integer)boundsJ.getValue2() <= (Integer)boundsI.getValue2()) continue;
                        newTypeBounds.put(new Pair(boundsI.getValue2(), boundsJ.getValue2()), boundsJ);
                        continue;
                    }
                    if ((Integer)boundsJ.getValue2() < (Integer)boundsI.getValue1() || (Integer)boundsJ.getValue2() > (Integer)boundsI.getValue2()) continue;
                    removalTypeBounds.add(boundsJ);
                    if ((Integer)boundsJ.getValue1() >= (Integer)boundsI.getValue1()) continue;
                    newTypeBounds.put(new Pair(boundsJ.getValue1(), boundsI.getValue1()), boundsJ);
                }
            }
            if (removalTypeBounds.isEmpty()) {
                return listTypes;
            }
            for (Map.Entry pairEntry : newTypeBounds.entrySet()) {
                listTypes.put((Pair<Integer>)pairEntry.getKey(), listTypes.get(pairEntry.getValue()));
            }
            removalTypeBounds.addAll(newTypeBounds.values());
            listTypes.keySet().removeAll(removalTypeBounds);
            if (listTypes.size() == 1) {
                return listTypes;
            }
            newTypeBounds.clear();
            removalTypeBounds.clear();
        }
    }

    private static Collection<Pair<Integer>> findEntrySeparators(String listText, Pattern entrySeparator) {
        HashSet<Pair<Integer>> separators = new HashSet<Pair<Integer>>();
        Matcher tagMatcher = entrySeparator.matcher(listText);
        while (tagMatcher.find()) {
            Pair<Integer> tagBounds = new Pair<Integer>(tagMatcher.start(), tagMatcher.end());
            separators.add(tagBounds);
        }
        return separators;
    }

    private static Collection<ListEntry> findListEntries(JCas jCas, Pair<Integer> listBounds, String listText, int offset, Pattern entrySeparator) {
        Collection<Pair<Integer>> separators = ListAnnotator.findEntrySeparators(listText, entrySeparator);
        int listBegin = listBounds.getValue1();
        int listEnd = listBounds.getValue2();
        if (separators.isEmpty()) {
            ListEntry listEntry = new ListEntry(jCas, offset + listBounds.getValue1(), offset + listBounds.getValue2());
            listEntry.addToIndexes();
            LOGGER.warn((Object)("One List Entry for " + listText));
            return Collections.singletonList(listEntry);
        }
        ArrayList<ListEntry> listEntries = new ArrayList<ListEntry>(separators.size() + 1);
        ArrayList<Pair<Integer>> boundsList = new ArrayList<Pair<Integer>>(separators);
        try {
            boundsList.sort((p1, p2) -> (Integer)p1.getValue1() - (Integer)p2.getValue2());
        }
        catch (IllegalArgumentException iaE) {
            LOGGER.error((Object)(iaE.getMessage() + ", ignoring possible list entries."));
            return Collections.emptyList();
        }
        int previousEntryEnd = listBegin;
        int length = boundsList.size();
        for (int i = 0; i < length; ++i) {
            Pair leftBounds = (Pair)boundsList.get(i);
            int entryBegin = previousEntryEnd;
            int entryEnd = listBegin + (Integer)leftBounds.getValue2();
            if (entryEnd - entryBegin <= 0) continue;
            ListEntry listEntry = new ListEntry(jCas, offset + entryBegin, offset + entryEnd);
            listEntry.addToIndexes();
            listEntries.add(listEntry);
            previousEntryEnd = entryEnd;
        }
        if (previousEntryEnd < listEnd) {
            ListEntry listEntry = new ListEntry(jCas, offset + previousEntryEnd, offset + listEnd);
            listEntry.addToIndexes();
            listEntries.add(listEntry);
        }
        return listEntries;
    }

    private static void createLists(JCas jcas, Map<Pair<Integer>, ListType> listTypes, String text, int offset) {
        if (listTypes == null || listTypes.isEmpty()) {
            return;
        }
        for (Map.Entry<Pair<Integer>, ListType> boundedListType : listTypes.entrySet()) {
            Pair<Integer> listBounds = boundedListType.getKey();
            ListType listType = boundedListType.getValue();
            Collection<ListEntry> listEntries = ListAnnotator.findListEntries(jcas, listBounds, text.substring(listBounds.getValue1(), listBounds.getValue2()), offset, listType.__entrySeparator);
            FSList fsList = FSCollectionFactory.createFSList((JCas)jcas, listEntries);
            fsList.addToIndexes();
            org.apache.ctakes.typesystem.type.textspan.List list = new org.apache.ctakes.typesystem.type.textspan.List(jcas, offset + listBounds.getValue1(), offset + listBounds.getValue2());
            list.setId(listType.__name);
            list.setItems(fsList);
            list.addToIndexes();
        }
    }

    private void parseBsvLine(String line) {
        if (line.isEmpty() || line.startsWith("#") || line.startsWith("//")) {
            return;
        }
        String[] splits = line.split("\\|\\|");
        if (splits.length < 3 || ListAnnotator.isBoolean(splits[1])) {
            LOGGER.warn((Object)("Bad List definition: " + line + " ; please use one of the following:\nNAME||LIST_REGEX||ENTRY_SEPARATOR_REGEX"));
            return;
        }
        String name = splits[0].trim();
        String listRegex = splits[1].trim();
        String separatorRegex = splits[2].trim();
        ListType listType = new ListType(name, listRegex, separatorRegex);
        this._listTypes.add(listType);
    }

    private static boolean isBoolean(String text) {
        String text2 = text.trim().toLowerCase();
        return text2.equalsIgnoreCase("true") || text2.equalsIgnoreCase("false");
    }

    public static AnalysisEngineDescription createEngineDescription(String sectionTypesPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ListAnnotator.class, (Object[])new Object[]{LIST_TYPES_PATH, sectionTypesPath});
    }

    private static final class ListType {
        private final String __name;
        private final Pattern __listPattern;
        private final Pattern __entrySeparator;

        private ListType(String name, String listRegex, String entrySplitRegex) {
            this.__name = name;
            this.__listPattern = listRegex == null ? null : Pattern.compile(listRegex, 8);
            this.__entrySeparator = entrySplitRegex == null ? null : Pattern.compile(entrySplitRegex, 8);
        }
    }
}

