/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.ctakes.typesystem.type.textspan.ListEntry;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@PipeBitInfo(name="List Entry Negator", description="Checks List Entries for negation, which may be exhibited differently from unstructured negation.", dependencies={PipeBitInfo.TypeProduct.LIST, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class ListEntryNegator
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"ListEntryNegator");
    private static final Pattern NEGATIVE_PATTERN = Pattern.compile("(?:\\s?:\\s*)(?:NEGATIVE|(?:NO\\.?\\b)|(?:N\\/A)|NONE|(?:NOT (?:APPLICABLE|INVOLVED|SEEN|PRESENT|INDICATED|FOUND|DISCOVERED)?)|DENIE[SD])", 2);

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Adjusting attributes within Lists ...");
        Collection lists = JCasUtil.select((JCas)jcas, org.apache.ctakes.typesystem.type.textspan.List.class);
        lists.forEach(l -> ListEntryNegator.processList(jcas, (AnnotationFS)l));
    }

    private static void processList(JCas jCas, AnnotationFS list) {
        ArrayList<ListEntry> listEntries = new ArrayList<ListEntry>(JCasUtil.selectCovered((JCas)jCas, ListEntry.class, (AnnotationFS)list));
        if (listEntries.isEmpty()) {
            return;
        }
        listEntries.sort(Comparator.comparingInt(AnnotationFS::getBegin));
        ArrayList<IdentifiedAnnotation> negatables = new ArrayList<IdentifiedAnnotation>();
        negatables.addAll(JCasUtil.selectCovered((JCas)jCas, DiseaseDisorderMention.class, (AnnotationFS)list));
        negatables.addAll(JCasUtil.selectCovered((JCas)jCas, SignSymptomMention.class, (AnnotationFS)list));
        negatables.sort(Comparator.comparingInt(AnnotationFS::getBegin));
        if (negatables.isEmpty()) {
            return;
        }
        ListEntryNegator.processNegatables(jCas.getDocumentText(), listEntries, negatables);
    }

    private static void processNegatables(String docText, Iterable<ListEntry> listEntries, List<IdentifiedAnnotation> negatables) {
        int j = 0;
        IdentifiedAnnotation negatable = negatables.get(0);
        for (ListEntry listEntry : listEntries) {
            int entryBegin = listEntry.getBegin();
            while (negatable.getEnd() < entryBegin) {
                if (++j >= negatables.size()) {
                    return;
                }
                negatable = negatables.get(j);
            }
            int entryEnd = listEntry.getEnd();
            while (negatable.getBegin() >= entryBegin && negatable.getEnd() < entryEnd) {
                String window = docText.substring(negatable.getEnd(), entryEnd);
                Matcher matcher = NEGATIVE_PATTERN.matcher(window);
                if (matcher.find()) {
                    negatable.setPolarity(-1);
                }
                if (++j >= negatables.size()) {
                    return;
                }
                negatable = negatables.get(j);
            }
        }
    }
}

