/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textspan.List;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="List Paragraph Fixer", description="Re-annotates Paragraphs based upon existing Lists, preventing a Paragraph from spanning more than one List.", dependencies={PipeBitInfo.TypeProduct.LIST, PipeBitInfo.TypeProduct.SENTENCE})
public final class ListParagraphFixer
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"ListSentenceFixer");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Adjusting Sentences overlapping Lists ...");
        Collection lists = JCasUtil.select((JCas)jcas, List.class);
        if (lists == null || lists.isEmpty()) {
            LOGGER.info((Object)"Finished Processing");
            return;
        }
        ListParagraphFixer.adjustListParagraphs(jcas);
        LOGGER.info((Object)"Finished Processing");
    }

    private static void adjustListParagraphs(JCas jCas) {
        Collection lists = JCasUtil.select((JCas)jCas, List.class);
        ArrayList<Paragraph> allParagraphs = new ArrayList<Paragraph>(JCasUtil.select((JCas)jCas, Paragraph.class));
        allParagraphs.sort(Comparator.comparingInt(Annotation::getBegin));
        HashMap<Paragraph, HashSet<Integer>> paragraphCrossBounds = new HashMap<Paragraph, HashSet<Integer>>();
        for (List list : lists) {
            Paragraph paragraph;
            Iterator iterator = allParagraphs.iterator();
            while (iterator.hasNext() && (paragraph = (Paragraph)iterator.next()).getBegin() <= list.getEnd()) {
                if (paragraph.getEnd() < list.getBegin() || paragraph.getBegin() >= list.getBegin() && paragraph.getEnd() <= list.getEnd()) continue;
                HashSet<Integer> crossBounds = (HashSet<Integer>)paragraphCrossBounds.get(paragraph);
                if (crossBounds == null) {
                    crossBounds = new HashSet<Integer>();
                    paragraphCrossBounds.put(paragraph, crossBounds);
                    crossBounds.add(paragraph.getBegin());
                    crossBounds.add(paragraph.getEnd());
                }
                crossBounds.add(Math.max(paragraph.getBegin(), list.getBegin()));
                crossBounds.add(Math.min(paragraph.getEnd(), list.getEnd()));
            }
        }
        for (Map.Entry entry : paragraphCrossBounds.entrySet()) {
            ArrayList sortedBounds = new ArrayList((Collection)entry.getValue());
            Collections.sort(sortedBounds);
            for (int i = 0; i < sortedBounds.size() - 1; ++i) {
                Paragraph paragraph = new Paragraph(jCas, ((Integer)sortedBounds.get(i)).intValue(), ((Integer)sortedBounds.get(i + 1)).intValue());
                if (WHITESPACE.matcher(paragraph.getCoveredText()).replaceAll(" ").trim().length() <= 0) continue;
                paragraph.addToIndexes();
            }
            ((Paragraph)entry.getKey()).removeFromIndexes();
            jCas.removeFsFromIndexes((FeatureStructure)entry.getKey());
        }
    }
}

