/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textspan.List;
import org.apache.ctakes.typesystem.type.textspan.ListEntry;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="List Sentence Splitter", description="Re-annotates Sentences based upon existing List Entries, preventing a Sentence from spanning more than one List Entry.", dependencies={PipeBitInfo.TypeProduct.LIST, PipeBitInfo.TypeProduct.SENTENCE})
public final class ListSentenceFixer
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"ListSentenceFixer");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Adjusting Sentences overlapping Lists ...");
        Collection lists = JCasUtil.select((JCas)jcas, List.class);
        if (lists == null || lists.isEmpty()) {
            return;
        }
        ListSentenceFixer.adjustListEntrySentences(jcas);
    }

    private static void adjustListEntrySentences(JCas jCas) {
        Collection listEntries = JCasUtil.select((JCas)jCas, ListEntry.class);
        ArrayList<Sentence> allSentences = new ArrayList<Sentence>(JCasUtil.select((JCas)jCas, Sentence.class));
        allSentences.sort(Comparator.comparingInt(Annotation::getBegin));
        HashMap<Sentence, HashSet<Integer>> sentenceCrossBounds = new HashMap<Sentence, HashSet<Integer>>();
        for (ListEntry listEntry : listEntries) {
            Sentence sentence;
            Iterator iterator = allSentences.iterator();
            while (iterator.hasNext() && (sentence = (Sentence)iterator.next()).getBegin() <= listEntry.getEnd()) {
                if (sentence.getEnd() < listEntry.getBegin() || sentence.getBegin() >= listEntry.getBegin() && sentence.getEnd() <= listEntry.getEnd()) continue;
                HashSet<Integer> crossBounds = (HashSet<Integer>)sentenceCrossBounds.get(sentence);
                if (crossBounds == null) {
                    crossBounds = new HashSet<Integer>();
                    sentenceCrossBounds.put(sentence, crossBounds);
                    crossBounds.add(sentence.getBegin());
                    crossBounds.add(sentence.getEnd());
                }
                crossBounds.add(Math.max(sentence.getBegin(), listEntry.getBegin()));
                crossBounds.add(Math.min(sentence.getEnd(), listEntry.getEnd()));
            }
        }
        for (Map.Entry entry : sentenceCrossBounds.entrySet()) {
            ArrayList sortedBounds = new ArrayList((Collection)entry.getValue());
            Collections.sort(sortedBounds);
            for (int i = 0; i < sortedBounds.size() - 1; ++i) {
                Sentence sentence = new Sentence(jCas, ((Integer)sortedBounds.get(i)).intValue(), ((Integer)sortedBounds.get(i + 1)).intValue());
                if (WHITESPACE.matcher(sentence.getCoveredText()).replaceAll(" ").trim().length() <= 0) continue;
                sentence.addToIndexes();
            }
            ((Sentence)entry.getKey()).removeFromIndexes();
            jCas.removeFsFromIndexes((FeatureStructure)entry.getKey());
        }
    }
}

