/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.Pair;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="Paragraph Sentence Splitter", description="Re-annotates Sentences based upon existing Paragraphs, preventing a Sentence from spanning more than one Paragraph.", dependencies={PipeBitInfo.TypeProduct.PARAGRAPH, PipeBitInfo.TypeProduct.SENTENCE})
public final class ParagraphSentenceFixer
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"ParagraphSentenceFixer");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Predicate<Sentence> notEmpty = s -> WHITESPACE.matcher(s.getCoveredText()).replaceAll(" ").trim().length() > 0;

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Adjusting Sentences overlapping Paragraphs ...");
        Collection paragraphs = JCasUtil.select((JCas)jcas, Paragraph.class);
        if (paragraphs == null || paragraphs.isEmpty()) {
            return;
        }
        ParagraphSentenceFixer.adjustParagraphSentences(jcas, paragraphs);
    }

    private static void adjustParagraphSentences(JCas jCas, Collection<Paragraph> paragraphs) {
        Collection allSentences = JCasUtil.select((JCas)jCas, Sentence.class);
        HashSet<Pair<Integer>> newBounds = new HashSet<Pair<Integer>>();
        HashMap<Sentence, Collection> boundarySentences = new HashMap<Sentence, Collection>();
        for (Paragraph paragraph : paragraphs) {
            for (Sentence sentence : allSentences) {
                if ((sentence.getBegin() >= paragraph.getBegin() || sentence.getEnd() <= paragraph.getBegin()) && (sentence.getEnd() <= paragraph.getEnd() || sentence.getBegin() >= paragraph.getEnd())) continue;
                boundarySentences.computeIfAbsent(sentence, p -> new HashSet()).add(paragraph);
            }
        }
        for (Map.Entry entry : boundarySentences.entrySet()) {
            int sentenceBegin = ((Sentence)entry.getKey()).getBegin();
            int sentenceEnd = ((Sentence)entry.getKey()).getEnd();
            List sorted = ((Collection)entry.getValue()).stream().sorted(Comparator.comparingInt(Annotation::getBegin)).collect(Collectors.toList());
            Paragraph first = (Paragraph)sorted.get(0);
            if (sentenceBegin < first.getBegin() && sentenceEnd > first.getBegin()) {
                newBounds.add(new Pair<Integer>(sentenceBegin, first.getBegin()));
                int end = Math.min(sentenceEnd, first.getEnd());
                newBounds.add(new Pair<Integer>(first.getBegin(), end));
            }
            for (int i = 0; i < sorted.size() - 1; ++i) {
                if (sentenceBegin > ((Paragraph)sorted.get(i)).getBegin() && sentenceEnd >= ((Paragraph)sorted.get(i)).getEnd()) {
                    newBounds.add(new Pair<Integer>(sentenceBegin, ((Paragraph)sorted.get(i)).getEnd()));
                }
                if (sentenceBegin < ((Paragraph)sorted.get(i + 1)).getBegin() && sentenceEnd <= ((Paragraph)sorted.get(i + 1)).getEnd()) {
                    newBounds.add(new Pair<Integer>(((Paragraph)sorted.get(i + 1)).getBegin(), sentenceEnd));
                }
                if (((Paragraph)sorted.get(i + 1)).getBegin() < ((Paragraph)sorted.get(i)).getEnd()) continue;
                newBounds.add(new Pair<Integer>(((Paragraph)sorted.get(i)).getEnd(), ((Paragraph)sorted.get(i + 1)).getBegin()));
            }
            Paragraph last = (Paragraph)sorted.get(sorted.size() - 1);
            if (sentenceEnd < last.getEnd() || sentenceBegin >= last.getEnd()) continue;
            int begin = Math.max(last.getBegin(), sentenceBegin);
            newBounds.add(new Pair<Integer>(begin, last.getEnd()));
            if (last.getEnd() >= sentenceEnd) continue;
            newBounds.add(new Pair<Integer>(last.getEnd(), sentenceEnd));
        }
        boundarySentences.keySet().forEach(TOP::removeFromIndexes);
        boundarySentences.keySet().forEach(arg_0 -> ((JCas)jCas).removeFsFromIndexes(arg_0));
        newBounds.stream().filter(p -> (Integer)p.getValue2() - (Integer)p.getValue1() > 0).map(p -> new Sentence(jCas, ((Integer)p.getValue1()).intValue(), ((Integer)p.getValue2()).intValue())).filter(notEmpty).forEach(TOP::addToIndexes);
    }
}

