/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.io.File;
import java.io.IOException;
import org.apache.ctakes.core.ae.inert.PausableAE;
import org.apache.ctakes.core.util.external.SystemUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class PausableFileLoggerAE
extends PausableAE {
    public static final String LOG_FILE_PARAM = "LogFile";
    public static final String LOG_FILE_DESC = "File to which cTAKES output should be sent.";
    @ConfigurationParameter(name="LogFile", description="File to which cTAKES output should be sent.", mandatory=false)
    private String _logFile;
    @ConfigurationParameter(name="OutputDirectory", description="Directory for all output files.")
    private File _outputRootDir;

    protected abstract boolean processPerDoc();

    protected abstract void runCommand() throws IOException;

    protected String getLogFile() {
        return this.getLogFile(this._logFile);
    }

    protected final String getLogFile(String logFile) {
        if (logFile == null || logFile.isEmpty()) {
            return "";
        }
        if (new File(logFile).getParent() != null) {
            return logFile;
        }
        if (!this._outputRootDir.exists()) {
            this._outputRootDir.mkdirs();
        }
        return this._outputRootDir + File.separator + logFile;
    }

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this._logFile = SystemUtil.subVariableParameters(this._logFile, context);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (!this.processPerDoc()) {
            return;
        }
        try {
            this.runCommand();
        }
        catch (IOException ioE) {
            throw new AnalysisEngineProcessException((Throwable)ioE);
        }
    }
}

