/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import com.lexicalscope.jewel.cli.CliFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Paths;
import org.apache.ctakes.core.pipeline.CliOptionals;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.pipeline.PipelineBuilder;
import org.apache.ctakes.core.pipeline.PiperFileReader;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="PiperFileRunEngine", description="Analysis Engine that executes the PiperFileRunner.  Kludge for desc files (CPE).", role=PipeBitInfo.Role.SPECIAL)
public class PiperFileRunEngine
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"PiperFileRunEngine");
    @ConfigurationParameter(name="PiperParams", description="Command Line Parameters normally used to run a piper file.")
    private String _piperParams;
    private AnalysisEngine _analysisEngine;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        String piperParams;
        super.initialize(context);
        if (this._piperParams == null) {
            PiperFileRunEngine.usage();
        }
        if ((piperParams = this._piperParams.trim()).startsWith("\"") && piperParams.endsWith("\"")) {
            piperParams = piperParams.substring(1, piperParams.length() - 1).trim();
        }
        if (piperParams.isEmpty()) {
            PiperFileRunEngine.usage();
        }
        LOGGER.info((Object)("Initializing Piper File with parameters " + piperParams + " ..."));
        this.initialize(piperParams.split("\\s+"));
    }

    private void initialize(String ... args) {
        CliOptionals options = (CliOptionals)CliFactory.parseArguments(CliOptionals.class, (String[])args);
        try {
            PiperFileReader reader = new PiperFileReader();
            PipelineBuilder builder = reader.getBuilder();
            String inputDir = options.getInputDirectory();
            if (!inputDir.isEmpty()) {
                builder.set("InputDirectory", inputDir);
            }
            String outputDir = options.getOutputDirectory();
            String xmiOutDir = options.getXmiOutDirectory();
            String htmlOutDir = options.getHtmlOutDirectory();
            if (!outputDir.isEmpty()) {
                builder.set("OutputDirectory", outputDir);
            } else if (!xmiOutDir.isEmpty()) {
                builder.set("OutputDirectory", xmiOutDir);
            } else if (!htmlOutDir.isEmpty()) {
                builder.set("OutputDirectory", htmlOutDir);
            }
            reader.setCliOptionals(options);
            reader.loadPipelineFile(options.getPiperPath());
            if (!xmiOutDir.isEmpty() && builder.getAeNames().stream().map(String::toLowerCase).noneMatch(n -> n.contains("xmiwriter"))) {
                builder.writeXMIs(xmiOutDir);
            }
            if (!htmlOutDir.isEmpty() && builder.getAeNames().stream().map(String::toLowerCase).noneMatch(n -> n.contains("htmlwriter"))) {
                builder.writeHtml(htmlOutDir);
            }
            AnalysisEngineDescription description = builder.getAnalysisEngineDesc();
            this._analysisEngine = AnalysisEngineFactory.createEngine((AnalysisEngineDescription)description, (Object[])new Object[0]);
        }
        catch (IOException | UIMAException multE) {
            PiperFileRunEngine.error((Exception)multE);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Running Pipeline ...");
        try {
            this._analysisEngine.process(jcas);
        }
        catch (AnalysisEngineProcessException aepE) {
            PiperFileRunEngine.error((Exception)((Object)aepE));
        }
    }

    private static void usage() {
        LOGGER.error((Object)"No Piper Parameters were specified using PiperParams.\nMandatory parameter is:\n -p piperFilePath\nTypical optional parameters are:\n -i inputDirectory\n -o outputDirectory\n --key umlsPassKey");
        System.exit(1);
    }

    private static void error(Exception multE) {
        LOGGER.error((Object)multE.getMessage());
        String logPath = Paths.get("cTAKES.error.log", new String[0]).toFile().getAbsolutePath();
        try {
            PrintStream stream = new PrintStream(logPath);
            multE.printStackTrace(stream);
            LOGGER.info((Object)("\nFor more information please see log file " + logPath));
            LOGGER.info((Object)"This is a log file on your machine listing information that may be useful in debugging your failed run.");
            LOGGER.info((Object)("Seriously, don't ignore this message.  If you want to get to the root of a problem, check the error log file " + logPath));
        }
        catch (FileNotFoundException fnfE) {
            LOGGER.warn((Object)("Could not write to log file " + logPath));
            multE.printStackTrace();
        }
        System.exit(1);
    }
}

