/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.io.File;
import java.io.IOException;
import org.apache.ctakes.core.ae.AbstractCommandRunner;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.external.SystemUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="PythonRunner", description="Starts a Python process with the given parameters.", role=PipeBitInfo.Role.SPECIAL)
public class PythonRunner
extends AbstractCommandRunner {
    private static final Logger LOGGER = Logger.getLogger((String)"PythonRunner");
    public static final String VENV_PARAM = "VirtualEnv";
    public static final String VENV_DESC = "Path to Python virtual environment.";
    @ConfigurationParameter(name="VirtualEnv", description="Path to Python virtual environment.", mandatory=false)
    private String _venv;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this._venv = SystemUtil.subVariableParameters(this._venv, context);
        if (this._venv != null && !this._venv.isEmpty() && !new File(this._venv).exists()) {
            LOGGER.warn((Object)("Cannot find Virtual Environment Directory " + this._venv));
        }
        if (this.processPerDoc()) {
            return;
        }
        try {
            this.runCommand();
        }
        catch (IOException ioE) {
            throw new ResourceInitializationException((Throwable)ioE);
        }
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (!this.processPerDoc()) {
            return;
        }
        try {
            this.runCommand();
        }
        catch (IOException ioE) {
            throw new AnalysisEngineProcessException((Throwable)ioE);
        }
    }

    private String getModule() {
        String command = this.getCommand().trim();
        int dashMindex = command.indexOf("-m ");
        if (dashMindex >= 0) {
            int spaceIndex = command.indexOf(32, dashMindex + 3);
            if (spaceIndex > 0) {
                return command.substring(dashMindex + 3, spaceIndex);
            }
            return command.substring(dashMindex + 3);
        }
        int spaceIndex = command.indexOf(32);
        if (spaceIndex < 0) {
            return command;
        }
        return command.substring(0, spaceIndex);
    }

    private String getModuleName() {
        int slashIndex;
        String module = this.getModule();
        if (module.endsWith(".py")) {
            module = module.substring(0, module.length() - 3);
        }
        if ((slashIndex = module.lastIndexOf(47)) < 0) {
            slashIndex = module.lastIndexOf(92);
        }
        if (slashIndex < 0) {
            slashIndex = module.lastIndexOf(46);
        }
        if (slashIndex >= 0) {
            return module.substring(slashIndex + 1);
        }
        return module;
    }

    @Override
    protected String getFullCommand() {
        String commandDir = this.getCommandDir();
        String command = this.getCommand();
        return commandDir == null || commandDir.isEmpty() ? "python -u " + command : commandDir + File.separator + "python -u " + command;
    }

    @Override
    protected void runCommand() throws IOException {
        String command = this.getFullCommand();
        SystemUtil.CommandRunner runner = new SystemUtil.CommandRunner(command);
        String logFile = this.getLogFile();
        if (logFile != null && !logFile.isEmpty()) {
            runner.setLogFiles(logFile);
        } else {
            Logger logger = this.getRunLogger();
            runner.setLogger(logger);
        }
        runner.wait(this.shouldWait());
        String workingDir = this.getWorkingDir();
        if (workingDir != null && !workingDir.isEmpty()) {
            runner.setDirectory(workingDir);
        }
        if (this._venv != null && !this._venv.trim().isEmpty()) {
            runner.setVenv(this._venv);
        }
        LOGGER.info((Object)("Starting " + command + " ..."));
        if (logFile != null && !logFile.isEmpty()) {
            LOGGER.info((Object)("Log File is " + logFile));
        }
        SystemUtil.run(runner);
        this.pause();
    }

    private Logger getRunLogger() {
        String logName = this.getLogName();
        if (logName != null && !logName.isEmpty()) {
            return Logger.getLogger((String)logName);
        }
        return Logger.getLogger((String)this.getModuleName());
    }

    public static AnalysisEngineDescription createEngineDescription(String venv, String command) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(PythonRunner.class, (Object[])new Object[]{VENV_PARAM, venv, "Command", command});
    }
}

