/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Start or Finish Logger", description="Simple Annotator to place before and after other annotators that do not Log their Start and Finish.", role=PipeBitInfo.Role.SPECIAL)
public class StartFinishLogger
extends JCasAnnotator_ImplBase {
    public static final String PARAM_LOGGER_NAME = "LOGGER_NAME";
    @ConfigurationParameter(name="LOGGER_NAME", description="provides the full name of the Annotator Engine for which start / end logging should be done.", defaultValue={"StartEndProgressLogger"})
    private String _loggerName;
    public static final String PARAM_LOGGER_TASK = "LOGGER_TASK";
    private static final String DEFAULT_TASK = "Processing ...";
    @ConfigurationParameter(name="LOGGER_TASK", mandatory=false, description="provides the descriptive purpose of the Annotator Engine for which start / end logging should be done.", defaultValue={"Processing ..."})
    private String _loggerTask;
    public static final String PARAM_IS_START = "IS_START";
    @ConfigurationParameter(name="IS_START", mandatory=false, description="indicates whether this should log a start.")
    private Boolean _isStart;
    private Logger _logger;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this._logger = Logger.getLogger((String)this._loggerName);
        if (this._isStart != null && this._isStart.booleanValue()) {
            if (this._loggerTask == null || this._loggerTask.equals(DEFAULT_TASK)) {
                this._logger.info((Object)"Starting initializing");
            } else {
                this._logger.info((Object)("Starting initializing for " + this._loggerTask));
            }
        } else {
            this._logger.info((Object)"Finished initializing");
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (this._isStart != null && this._isStart.booleanValue()) {
            if (this._loggerTask == null || this._loggerTask.equals(DEFAULT_TASK)) {
                this._logger.info((Object)"Starting processing ...");
            } else {
                this._logger.info((Object)(this._loggerTask + " ..."));
            }
        } else if (this._loggerTask == null || this._loggerTask.equals(DEFAULT_TASK)) {
            this._logger.info((Object)"Finished processing");
        } else {
            this._logger.info((Object)("Finished " + this._loggerTask));
        }
    }

    public static AnalysisEngine createEngine(String loggerName, boolean isStart) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngine(StartFinishLogger.class, (Object[])new Object[]{PARAM_LOGGER_NAME, loggerName, PARAM_IS_START, isStart});
    }

    public static AnalysisEngineDescription createDescription(String loggerName, boolean isStart) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(StartFinishLogger.class, (Object[])new Object[]{PARAM_LOGGER_NAME, loggerName, PARAM_IS_START, isStart});
    }

    public static AnalysisEngine createLoggedEngine(Class<? extends AnalysisComponent> classType, Object ... parameters) throws ResourceInitializationException {
        AnalysisEngineDescription description = StartFinishLogger.createLoggedDescription(classType, parameters);
        return AnalysisEngineFactory.createEngine((AnalysisEngineDescription)description, (Object[])parameters);
    }

    public static AnalysisEngineDescription createLoggedDescription(Class<? extends AnalysisComponent> classType, Object ... parameters) throws ResourceInitializationException {
        AnalysisEngineDescription mainDescription = AnalysisEngineFactory.createEngineDescription(classType, (Object[])parameters);
        return StartFinishLogger.createLoggedDescription(mainDescription);
    }

    public static AnalysisEngineDescription createLoggedDescription(AnalysisEngineDescription mainDescription) throws ResourceInitializationException {
        String name = mainDescription.getAnnotatorImplementationName();
        return AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])new AnalysisEngineDescription[]{StartFinishLogger.createDescription(name, true), mainDescription, StartFinishLogger.createDescription(name, false)});
    }
}

