/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.ctakes.typesystem.type.refsem.Attribute;
import org.apache.ctakes.typesystem.type.refsem.Date;
import org.apache.ctakes.typesystem.type.refsem.MedicationDosage;
import org.apache.ctakes.typesystem.type.refsem.MedicationDuration;
import org.apache.ctakes.typesystem.type.refsem.MedicationForm;
import org.apache.ctakes.typesystem.type.refsem.MedicationFrequency;
import org.apache.ctakes.typesystem.type.refsem.MedicationRoute;
import org.apache.ctakes.typesystem.type.refsem.MedicationStatusChange;
import org.apache.ctakes.typesystem.type.refsem.MedicationStrength;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.DegreeOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MedicationDosageModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationDurationModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationEventMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationFormModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationFrequencyModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationRouteModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationStatusChangeModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationStrengthModifier;
import org.apache.ctakes.typesystem.type.textsem.Modifier;
import org.apache.ctakes.typesystem.type.textsem.ProcedureMention;
import org.apache.ctakes.typesystem.type.textsem.SignSymptomMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class TemplateFillerAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"TemplateFillerAnnotator");

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
    }

    private void setAttributesFromOriginal(IdentifiedAnnotation mention, IdentifiedAnnotation original) throws CASException {
        mention.setBegin(original.getBegin());
        mention.setEnd(original.getEnd());
        mention.setConditional(original.getConditional());
        mention.setConfidence(original.getConfidence());
        mention.setDiscoveryTechnique(original.getDiscoveryTechnique());
        mention.setGeneric(original.getGeneric());
        mention.setOntologyConceptArr(original.getOntologyConceptArr());
        mention.setPolarity(original.getPolarity());
        mention.setSegmentID(original.getSegmentID());
        mention.setSentenceID(original.getSentenceID());
        mention.setSubject(original.getSubject());
        mention.setTypeID(original.getTypeID());
        mention.setUncertainty(original.getUncertainty());
        mention.setHistoryOf(original.getHistoryOf());
        if (original instanceof MedicationEventMention) {
            TimeMention timeMention;
            Date date;
            MedicationEventMention medEventMention = (MedicationEventMention)original;
            MedicationMention medMention = (MedicationMention)mention;
            JCas jcas = medMention.getCAS().getJCas();
            if (medEventMention.getStartDate() != null) {
                date = medEventMention.getStartDate();
                timeMention = new TimeMention(jcas);
                timeMention.setDate(date);
                medMention.setStartDate(timeMention);
            }
            if (medEventMention.getEndDate() != null) {
                date = medEventMention.getEndDate();
                timeMention = new TimeMention(jcas);
                timeMention.setDate(date);
                medMention.setEndDate(timeMention);
            }
            if (medEventMention.getMedicationDosage() != null) {
                MedicationDosage dosage = medEventMention.getMedicationDosage();
                MedicationDosageModifier medDosageModifier = new MedicationDosageModifier(jcas);
                medDosageModifier.setNormalizedForm((Attribute)dosage);
                medDosageModifier.setCategory(dosage.getValue());
                medMention.setMedicationDosage(medDosageModifier);
            }
            if (medEventMention.getMedicationDuration() != null) {
                MedicationDuration duration = medEventMention.getMedicationDuration();
                MedicationDurationModifier medDurationModifier = new MedicationDurationModifier(jcas);
                medDurationModifier.setNormalizedForm((Attribute)duration);
                medDurationModifier.setCategory(duration.getValue());
                medMention.setMedicationDuration(medDurationModifier);
            }
            if (medEventMention.getMedicationForm() != null) {
                MedicationForm form = medEventMention.getMedicationForm();
                MedicationFormModifier medFormModifier = new MedicationFormModifier(jcas);
                medFormModifier.setNormalizedForm((Attribute)form);
                medFormModifier.setCategory(form.getValue());
                medMention.setMedicationForm(medFormModifier);
            }
            if (medEventMention.getMedicationFrequency() != null) {
                MedicationFrequency frequency = medEventMention.getMedicationFrequency();
                MedicationFrequencyModifier medFrequencyModifier = new MedicationFrequencyModifier(jcas);
                medFrequencyModifier.setNormalizedForm((Attribute)frequency);
                medFrequencyModifier.setCategory(frequency.getNumber() + frequency.getUnit());
                medMention.setMedicationFrequency(medFrequencyModifier);
            }
            if (medEventMention.getMedicationRoute() != null) {
                MedicationRoute route = medEventMention.getMedicationRoute();
                MedicationRouteModifier medRouteModifier = new MedicationRouteModifier(jcas);
                medRouteModifier.setNormalizedForm((Attribute)route);
                medRouteModifier.setCategory(route.getValue());
                medMention.setMedicationRoute(medRouteModifier);
            }
            if (medEventMention.getMedicationStatusChange() != null) {
                MedicationStatusChange statusChange = medEventMention.getMedicationStatusChange();
                MedicationStatusChangeModifier medStatusChangeModifier = new MedicationStatusChangeModifier(jcas);
                medStatusChangeModifier.setNormalizedForm((Attribute)statusChange);
                medStatusChangeModifier.setCategory(statusChange.getValue());
                medMention.setMedicationStatusChange(medStatusChangeModifier);
            }
            if (medEventMention.getMedicationStrength() != null) {
                MedicationStrength strength = medEventMention.getMedicationStrength();
                MedicationStrengthModifier medStrengthModifier = new MedicationStrengthModifier(jcas);
                medStrengthModifier.setNormalizedForm((Attribute)strength);
                medStrengthModifier.setCategory(strength.getNumber() + strength.getUnit());
                medMention.setMedicationStrength(medStrengthModifier);
            }
        }
        mention.addToIndexes();
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String relation;
        RelationArgument arg2;
        RelationArgument arg1;
        BinaryTextRelation binaryTextRelation;
        LOGGER.debug((Object)("process(JCas) in " + TemplateFillerAnnotator.class.getName()));
        FSIterator<Annotation> identifiedAnnotationsIter = this.getAllAnnotations(jcas, IdentifiedAnnotation.type);
        HashMap<IdentifiedAnnotation, Object> mapToMentions = new HashMap<IdentifiedAnnotation, Object>();
        ArrayList<IdentifiedAnnotation> annotationsToRemoveFromCas = new ArrayList<IdentifiedAnnotation>();
        try {
            while (identifiedAnnotationsIter.hasNext()) {
                IdentifiedAnnotation original = (IdentifiedAnnotation)identifiedAnnotationsIter.next();
                MedicationMention mention = null;
                int t = original.getTypeID();
                if (t == 6 || t == 2 || t == 2 || t == 3 || t == 5) {
                    mapToMentions.put(original, original);
                    continue;
                }
                if (t != 1 || !(original instanceof MedicationEventMention)) continue;
                mention = new MedicationMention(jcas);
                mapToMentions.put(original, mention);
                this.setAttributesFromOriginal((IdentifiedAnnotation)mention, original);
                annotationsToRemoveFromCas.add(original);
            }
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        FSIndex locationOfTextRelations = jcas.getFSIndexRepository().getIndex("_org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation_GeneratedIndex");
        FSIndex degreeOfTextRelations = jcas.getFSIndexRepository().getIndex("_org.apache.ctakes.typesystem.type.relation.DegreeOfTextRelation_GeneratedIndex");
        int i = 0;
        if (locationOfTextRelations != null) {
            for (FeatureStructure binaryTextRelationFS : locationOfTextRelations) {
                ++i;
                binaryTextRelation = (BinaryTextRelation)binaryTextRelationFS;
                LocationOfTextRelation locationOfTextRelation = null;
                if (binaryTextRelation instanceof LocationOfTextRelation) {
                    locationOfTextRelation = (LocationOfTextRelation)binaryTextRelationFS;
                }
                arg1 = binaryTextRelation.getArg1();
                arg2 = binaryTextRelation.getArg2();
                relation = binaryTextRelation.getCategory();
                if (relation.equals("degree_of")) continue;
                if (relation.equals("location_of")) {
                    IdentifiedAnnotation arg1Arg = (IdentifiedAnnotation)arg1.getArgument();
                    IdentifiedAnnotation ia = (IdentifiedAnnotation)mapToMentions.get(arg1Arg);
                    if (ia instanceof EntityMention) {
                        EntityMention entityMention = (EntityMention)ia;
                        IdentifiedAnnotation location = (IdentifiedAnnotation)arg2.getArgument();
                        IdentifiedAnnotation loc = (IdentifiedAnnotation)mapToMentions.get(location);
                        if (loc instanceof AnatomicalSiteMention) {
                            AnatomicalSiteMention anatomicalSiteMention = (AnatomicalSiteMention)loc;
                            continue;
                        }
                        LOGGER.error((Object)("Need to implement cases for handling EntityMention " + entityMention + " within relation: " + relation));
                        LOGGER.error((Object)("   loc " + loc + " in relation " + relation + " with/to " + entityMention));
                        LOGGER.error((Object)("   Using covered text: loc " + loc.getCoveredText() + " in relation " + relation + " with/to " + entityMention.getCoveredText()));
                        continue;
                    }
                    EventMention eventMention = (EventMention)ia;
                    if (eventMention instanceof DiseaseDisorderMention) {
                        DiseaseDisorderMention ddm = (DiseaseDisorderMention)eventMention;
                        ddm.setBodyLocation(locationOfTextRelation);
                        continue;
                    }
                    if (eventMention instanceof ProcedureMention) {
                        ProcedureMention pm = (ProcedureMention)eventMention;
                        pm.setBodyLocation(locationOfTextRelation);
                        continue;
                    }
                    if (eventMention instanceof SignSymptomMention) {
                        SignSymptomMention ssm = (SignSymptomMention)eventMention;
                        ssm.setBodyLocation(locationOfTextRelation);
                        continue;
                    }
                    LOGGER.error((Object)("Need to implement more cases for handling EventMention " + eventMention + " within relation: " + relation));
                    continue;
                }
                LOGGER.error((Object)("Need to implement more cases for relation: " + relation));
            }
        }
        if (degreeOfTextRelations != null) {
            for (FeatureStructure binaryTextRelationFS : degreeOfTextRelations) {
                ++i;
                binaryTextRelation = (BinaryTextRelation)binaryTextRelationFS;
                DegreeOfTextRelation degreeOfTextRelation = null;
                if (binaryTextRelation instanceof DegreeOfTextRelation) {
                    degreeOfTextRelation = (DegreeOfTextRelation)binaryTextRelationFS;
                }
                arg1 = binaryTextRelation.getArg1();
                arg2 = binaryTextRelation.getArg2();
                relation = binaryTextRelation.getCategory();
                if (relation.equals("degree_of")) {
                    Modifier severity = (Modifier)arg2.getArgument();
                    IdentifiedAnnotation arg1Arg = (IdentifiedAnnotation)arg1.getArgument();
                    IdentifiedAnnotation ia = (IdentifiedAnnotation)mapToMentions.get(arg1Arg);
                    if (ia instanceof EntityMention) {
                        EntityMention entityMention = (EntityMention)ia;
                        LOGGER.error((Object)("Need to implement cases for handling EntityMention " + entityMention + " within relation: " + relation));
                        LOGGER.error((Object)("   severity " + severity + " in relation " + relation + " with/to " + entityMention));
                        LOGGER.error((Object)("   Using covered text: severity " + severity.getCoveredText() + " in relation " + relation + " with/to " + entityMention.getCoveredText()));
                        continue;
                    }
                    EventMention eventMention = (EventMention)ia;
                    if (eventMention instanceof DiseaseDisorderMention) {
                        DiseaseDisorderMention ddm = (DiseaseDisorderMention)eventMention;
                        ddm.setSeverity(degreeOfTextRelation);
                        continue;
                    }
                    if (eventMention instanceof SignSymptomMention) {
                        SignSymptomMention ssm = (SignSymptomMention)eventMention;
                        ssm.setSeverity(degreeOfTextRelation);
                        continue;
                    }
                    LOGGER.error((Object)("Need to implement more cases for handling EventMention " + eventMention + " within relation: " + relation));
                    continue;
                }
                if (relation.equals("location_of")) continue;
                LOGGER.error((Object)("Need to implement more cases for relation: " + relation));
            }
        }
    }

    private FSIterator<Annotation> getAllAnnotations(JCas jcas, int type) {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        FSIterator annotationsIter = indexes.getAnnotationIndex(type).iterator();
        return annotationsIter;
    }
}

