/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae.inert;

import java.io.IOException;
import org.apache.ctakes.core.util.log.DotLogger;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class PausableAE
extends JCasAnnotator_ImplBase {
    public static final String PAUSE_PARAM = "Pause";
    public static final String PAUSE_DESC = "Pause for some seconds.  Default is 0";
    @ConfigurationParameter(name="Pause", description="Pause for some seconds.  Default is 0", mandatory=false)
    private int _pause = 0;
    public static final String WAIT_PARAM = "Wait";
    public static final String WAIT_DESC = "Wait for the process to finish.  Default is no.";
    @ConfigurationParameter(name="Wait", description="Wait for the process to finish.  Default is no.", defaultValue={"no"}, mandatory=false)
    private String _wait;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
    }

    protected void logInfo(String info) {
    }

    protected boolean shouldWait() {
        return this._wait.equalsIgnoreCase("yes") || this._wait.equalsIgnoreCase("true");
    }

    protected final void pause() {
        if (this._pause < 1) {
            return;
        }
        long pause = (long)this._pause * 1000L;
        this.logInfo("Pausing " + this._pause + " seconds ...");
        try (DotLogger dotter = new DotLogger();){
            Thread.sleep(pause);
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }
}

