/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.typesystem.type.structured.DocumentIdPrefix;
import org.apache.ctakes.typesystem.type.structured.DocumentPath;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class AbstractFileWriter<T>
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"AbstractOutputFileWriter");
    @ConfigurationParameter(name="OutputDirectory", description="Directory for all output files.")
    private File _outputRootDir;
    @ConfigurationParameter(name="SubDirectory", description="SubDirectory for files.", mandatory=false, defaultValue={""})
    private String _subDirectory;
    private static final Object DATA_LOCK = new Object();

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        if (this._subDirectory != null && !this._subDirectory.isEmpty()) {
            File subDirectory = new File(this._outputRootDir, this._subDirectory);
            if (!subDirectory.exists()) {
                subDirectory.mkdirs();
            }
        } else if (!this._outputRootDir.exists()) {
            this._outputRootDir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String documentId = DocIdUtil.getDocumentIdForFile(jcas);
        String outputDir = this.getOutputDirectory(jcas, this.getRootDirectory(), documentId);
        String fileName = this.getSourceFileName(jcas, documentId);
        try {
            Object object = DATA_LOCK;
            synchronized (object) {
                this.createData(jcas);
                T data = this.getData();
                this.writeFile(data, outputDir, documentId, fileName);
                this.writeComplete(data);
            }
        }
        catch (IOException ioE) {
            throw new AnalysisEngineProcessException((Throwable)ioE);
        }
    }

    protected abstract void createData(JCas var1);

    protected abstract T getData();

    protected abstract void writeComplete(T var1);

    public abstract void writeFile(T var1, String var2, String var3, String var4) throws IOException;

    protected String getRootDirectory() {
        return this._outputRootDir.getPath();
    }

    protected String getSimpleSubDirectory() {
        return this._subDirectory;
    }

    protected String getOutputDirectory(JCas jcas, String rootPath, String documentId) {
        String subDirectory = this.getSubdirectory(jcas, documentId);
        if (subDirectory == null || subDirectory.isEmpty()) {
            return rootPath;
        }
        File outputDir = new File(rootPath + "/" + subDirectory);
        outputDir.mkdirs();
        return outputDir.getPath();
    }

    protected String getSubdirectory(JCas jCas, String documentId) {
        Collection prefices;
        String subDirectory = "";
        String subSeparator = "";
        String simpleSubDir = this.getSimpleSubDirectory();
        if (simpleSubDir != null && !simpleSubDir.isEmpty()) {
            subDirectory = simpleSubDir;
            subSeparator = "/";
        }
        if ((prefices = JCasUtil.select((JCas)jCas, DocumentIdPrefix.class)) == null || prefices.isEmpty()) {
            LOGGER.debug((Object)("No subdirectory information for " + documentId));
            return subDirectory;
        }
        for (DocumentIdPrefix prefix : prefices) {
            String docSubDirectory = prefix.getDocumentIdPrefix();
            if (docSubDirectory == null || docSubDirectory.isEmpty()) continue;
            return subDirectory + subSeparator + docSubDirectory;
        }
        LOGGER.debug((Object)("No subdirectory information for " + documentId));
        return subDirectory;
    }

    protected String getSourceFilePath(JCas jCas) {
        Collection documentPaths = JCasUtil.select((JCas)jCas, DocumentPath.class);
        if (documentPaths == null || documentPaths.isEmpty()) {
            return "";
        }
        for (DocumentPath documentPath : documentPaths) {
            String path = documentPath.getDocumentPath();
            if (path == null || path.isEmpty()) continue;
            return path;
        }
        return "";
    }

    protected String getSourceFileName(JCas jcas, String documentId) {
        String path = this.getSourceFilePath(jcas);
        if (path != null && !path.isEmpty()) {
            return new File(path).getName();
        }
        return documentId;
    }
}

