/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ctakes.core.resource.JdbcConnectionResource;
import org.apache.ctakes.core.util.doc.SourceMetadataUtil;
import org.apache.ctakes.typesystem.type.structured.SourceData;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;

public abstract class AbstractJdbcWriter
extends CasConsumer_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"AbstractJdbcWriter");
    public static final String PARAM_DB_CONN_RESRC = "DbConnResrcName";
    private static final int MAX_BATCH_SIZE = 100;
    protected final Map<String, TableSqlInfo> _tableSqlInfoMap = new HashMap<String, TableSqlInfo>();

    public void initialize() throws ResourceInitializationException {
        JdbcConnectionResource resource;
        String resourceName = (String)this.getConfigParameterValue(PARAM_DB_CONN_RESRC);
        try {
            resource = (JdbcConnectionResource)this.getUimaContext().getResourceObject(resourceName);
        }
        catch (ResourceAccessException raE) {
            throw new ResourceInitializationException((Throwable)raE);
        }
        Connection connection = resource.getConnection();
        Collection<TableInfo> tableInfos = this.getTableInfos();
        try {
            for (TableInfo tableInfo : tableInfos) {
                this._tableSqlInfoMap.put(tableInfo.getTableName(), new TableSqlInfo(connection, tableInfo));
            }
        }
        catch (SQLException sqlE) {
            throw new ResourceInitializationException((Throwable)sqlE);
        }
    }

    public void collectionProcessComplete(ProcessTrace arg0) throws ResourceProcessException, IOException {
        try {
            for (TableSqlInfo tableSqlInfo : this._tableSqlInfoMap.values()) {
                tableSqlInfo.__preparedStatement.close();
            }
        }
        catch (SQLException sqlE) {
            LOGGER.warn((Object)sqlE.getMessage());
        }
        super.collectionProcessComplete(arg0);
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException casE) {
            throw new ResourceProcessException((Throwable)casE);
        }
        SourceData sourceData = SourceMetadataUtil.getSourceData(jcas);
        if (sourceData == null) {
            LOGGER.error((Object)"Missing source metadata for document.");
            return;
        }
        long patientNum = SourceMetadataUtil.getPatientNum(jcas);
        int encounterNum = SourceMetadataUtil.getEncounterNum(sourceData);
        String providerId = SourceMetadataUtil.getProviderId(sourceData);
        Timestamp startDate = SourceMetadataUtil.getStartDate(sourceData);
        try {
            this.writeJCasInformation(jcas, encounterNum, patientNum, providerId, startDate);
            for (TableSqlInfo tableSqlInfo : this._tableSqlInfoMap.values()) {
                if (tableSqlInfo.getBatchCount() <= 0) continue;
                tableSqlInfo.getPreparedStatement().executeBatch();
                tableSqlInfo.getPreparedStatement().clearBatch();
                tableSqlInfo.setBatchCount(0);
            }
        }
        catch (SQLException sqlE) {
            throw new ResourceProcessException((Throwable)sqlE);
        }
    }

    protected abstract Collection<TableInfo> getTableInfos();

    protected abstract void writeJCasInformation(JCas var1, int var2, long var3, String var5, Timestamp var6) throws SQLException;

    protected Map<String, TableSqlInfo> getTableSqlInfoMap() {
        return this._tableSqlInfoMap;
    }

    protected static void setFieldInfoValue(Map<FieldInfo, Object> fieldInfoMap, FieldInfo fieldInfo, Object value) {
        Class<?> valueClass = fieldInfo.getValueClass();
        if (!valueClass.isInstance(value)) {
            throw new IllegalArgumentException("Invalid Value for Field " + fieldInfo.getFieldName());
        }
        fieldInfoMap.put(fieldInfo, value);
    }

    protected static int writeTableRow(PreparedStatement preparedStatement, int batchSize, Map<? extends FieldInfo, Object> fieldInfoMap) throws SQLException {
        for (Map.Entry<? extends FieldInfo, Object> fieldInfoEntry : fieldInfoMap.entrySet()) {
            int fieldIndex = fieldInfoEntry.getKey().getFieldIndex();
            Class<Object> valueClass = fieldInfoEntry.getKey().getValueClass();
            Object value = fieldInfoEntry.getValue();
            if (valueClass.isAssignableFrom(String.class) && String.class.isInstance(value)) {
                preparedStatement.setString(fieldIndex, (String)value);
                continue;
            }
            if (valueClass.isAssignableFrom(Integer.class) && Integer.class.isInstance(value)) {
                preparedStatement.setInt(fieldIndex, (Integer)value);
                continue;
            }
            if (valueClass.isAssignableFrom(Long.class) && Long.class.isInstance(value)) {
                preparedStatement.setLong(fieldIndex, (Long)value);
                continue;
            }
            if (valueClass.isAssignableFrom(Float.class) && Float.class.isInstance(value)) {
                preparedStatement.setFloat(fieldIndex, ((Float)value).floatValue());
                continue;
            }
            if (valueClass.isAssignableFrom(Double.class) && Double.class.isInstance(value)) {
                preparedStatement.setDouble(fieldIndex, (Double)value);
                continue;
            }
            if (valueClass.isAssignableFrom(Boolean.class) && Boolean.class.isInstance(value)) {
                preparedStatement.setBoolean(fieldIndex, (Boolean)value);
                continue;
            }
            if (valueClass.isAssignableFrom(Timestamp.class) && Timestamp.class.isInstance(value)) {
                preparedStatement.setTimestamp(fieldIndex, (Timestamp)value);
                continue;
            }
            throw new SQLDataException("Invalid Value Class for Field " + fieldInfoEntry.getKey().getFieldName());
        }
        preparedStatement.addBatch();
        if (batchSize + 1 >= 100) {
            preparedStatement.executeBatch();
            preparedStatement.clearBatch();
            return 0;
        }
        return batchSize + 1;
    }

    protected static String createRowInsertSql(String tableName, FieldInfo ... fieldInfos) throws SQLDataException {
        if (fieldInfos.length == 0) {
            throw new SQLDataException("Must set at least one Field to create an sql insert Statement");
        }
        StringBuilder statement = new StringBuilder("insert into");
        StringBuilder queries = new StringBuilder();
        statement.append(" ").append(tableName);
        statement.append(" (");
        for (FieldInfo fieldInfo : fieldInfos) {
            statement.append(fieldInfo.getFieldName()).append(",");
            queries.append("?,");
        }
        statement.setLength(statement.length() - 1);
        queries.setLength(queries.length() - 1);
        statement.append(") values (").append((CharSequence)queries).append(")");
        return statement.toString();
    }

    protected static class TableSqlInfo {
        private final PreparedStatement __preparedStatement;
        private int __batchCount;

        protected TableSqlInfo(Connection connection, TableInfo tableInfo) throws SQLException {
            String sql = AbstractJdbcWriter.createRowInsertSql(tableInfo.getTableName(), tableInfo.getFieldInfos());
            this.__preparedStatement = connection.prepareStatement(sql);
        }

        protected PreparedStatement getPreparedStatement() {
            return this.__preparedStatement;
        }

        protected void setBatchCount(int batchCount) {
            this.__batchCount = batchCount;
        }

        protected int getBatchCount() {
            return this.__batchCount;
        }
    }

    protected static interface FieldInfo {
        public String getFieldName();

        public int getFieldIndex();

        public Class<?> getValueClass();
    }

    protected static interface TableInfo {
        public String getTableName();

        public FieldInfo[] getFieldInfos();
    }
}

