/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ctakes.core.cc.AbstractFileWriter;
import org.apache.log4j.Logger;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;

public abstract class AbstractTableFileWriter
extends AbstractFileWriter<List<List<String>>> {
    private static final Logger LOGGER = Logger.getLogger((String)"AbstractTableFileWriter");
    @ConfigurationParameter(name="TableType", description="Type of Table to write to File. Possible values are: BSV, CSV, HTML, TAB", mandatory=false)
    private String _tableType;
    private final List<String> _headerRow = new ArrayList<String>();
    private final List<List<String>> _dataRows = new ArrayList<List<String>>();
    private final List<String> _footerRow = new ArrayList<String>();

    protected abstract List<List<String>> createDataRows(JCas var1);

    protected List<String> createHeaderRow(JCas jCas) {
        return Collections.emptyList();
    }

    protected final List<String> getHeaderRow() {
        return this._headerRow;
    }

    protected List<String> createFooterRow(JCas jCas) {
        return Collections.emptyList();
    }

    protected final List<String> getFooterRow() {
        return this._footerRow;
    }

    @Override
    protected void createData(JCas jCas) {
        List<String> footer;
        List<List<String>> rows;
        this._headerRow.clear();
        this._dataRows.clear();
        this._footerRow.clear();
        List<String> header = this.createHeaderRow(jCas);
        if (header != null) {
            this._headerRow.addAll(header);
        }
        if ((rows = this.createDataRows(jCas)) != null) {
            this._dataRows.addAll(rows);
        }
        if ((footer = this.createFooterRow(jCas)) != null) {
            this._footerRow.addAll(footer);
        }
    }

    @Override
    protected List<List<String>> getData() {
        return this._dataRows;
    }

    @Override
    protected void writeComplete(List<List<String>> data) {
    }

    @Override
    public void writeFile(List<List<String>> dataRows, String outputDir, String documentId, String fileName) throws IOException {
        TableType tableType = Arrays.stream(TableType.values()).filter(s -> s.name().equalsIgnoreCase(this._tableType)).findFirst().orElse(TableType.BSV);
        File file = new File(outputDir, documentId + "_table." + tableType.name());
        LOGGER.info((Object)("Writing " + tableType.name() + " Table to " + file.getPath() + " ..."));
        String header = this.createTableHeader(tableType, this.getHeaderRow());
        String footer = this.createTableFooter(tableType, this.getFooterRow());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(header);
            for (List<String> dataRow : dataRows) {
                String row = this.createTableRow(tableType, dataRow);
                writer.write(row);
            }
            writer.write(footer);
        }
    }

    protected String createHtmlStyle() {
        return "table {\n  margin-left: auto;\n  margin-right: auto;\n}\n";
    }

    protected String createTableHeader(TableType tableType, List<String> headerRow) {
        switch (tableType) {
            case BSV: {
                return String.join((CharSequence)"|", headerRow) + "\n";
            }
            case CSV: {
                return String.join((CharSequence)",", headerRow) + "\n";
            }
            case TAB: {
                return String.join((CharSequence)"\t", headerRow) + "\n";
            }
            case HTML: {
                return this.createHtmlHeader(headerRow);
            }
        }
        return String.join((CharSequence)"|", headerRow) + "\n";
    }

    protected String createHtmlHeader(List<String> headerRow) {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>\n<html>\n<head>\n<style>\n");
        sb.append(this.createHtmlStyle());
        sb.append("</style>\n</head>\n<body>\n\n<table>\n <thead>\n  <tr>\n");
        for (String cell : headerRow) {
            sb.append("    <th>").append(cell).append("</th>\n");
        }
        sb.append("  </tr>\n </thead>\n");
        return sb.toString();
    }

    protected String createTableRow(TableType tableType, List<String> dataRow) {
        switch (tableType) {
            case BSV: {
                return String.join((CharSequence)"|", dataRow) + "\n";
            }
            case CSV: {
                return String.join((CharSequence)",", dataRow) + "\n";
            }
            case TAB: {
                return String.join((CharSequence)"\t", dataRow) + "\n";
            }
            case HTML: {
                return this.createHtmlRow(dataRow);
            }
        }
        return String.join((CharSequence)"|", dataRow) + "\n";
    }

    protected String createHtmlRow(List<String> dataRow) {
        StringBuilder sb = new StringBuilder();
        for (String cell : dataRow) {
            sb.append("    <td>").append(cell).append("</td>\n");
        }
        return "  <tr>\n" + sb.toString() + "  </tr>\n";
    }

    protected String createTableFooter(TableType tableType, List<String> footerRow) {
        switch (tableType) {
            case BSV: {
                return String.join((CharSequence)"|", footerRow) + "\n";
            }
            case CSV: {
                return String.join((CharSequence)",", footerRow) + "\n";
            }
            case TAB: {
                return String.join((CharSequence)"\t", footerRow) + "\n";
            }
            case HTML: {
                return this.createHtmlFooter(footerRow);
            }
        }
        return String.join((CharSequence)"|", footerRow) + "\n";
    }

    protected String createHtmlFooter(List<String> footerRow) {
        StringBuilder sb = new StringBuilder();
        sb.append(" <tfoot>\n  <tf>\n");
        for (String cell : footerRow) {
            sb.append("    <td>").append(cell).append("</td>\n");
        }
        sb.append("  </tf>\n <tfoot>\n</table>\n</body>\n</html>\n");
        return sb.toString();
    }

    protected static enum TableType {
        BSV,
        CSV,
        HTML,
        TAB;

    }
}

