/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

@PipeBitInfo(name="XMI Writer 2", description="Writes XMI files with full representation of input text and all extracted information.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public class CasConsumer
extends CasConsumer_ImplBase {
    private Logger iv_logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String iv_outputDir = null;
    private int iv_procCount = 0;

    public void initialize() throws ResourceInitializationException {
        this.iv_outputDir = (String)this.getConfigParameterValue("outputDir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processView(JCas view) throws Exception {
        String docName = DocIdUtil.getDocumentID(view);
        docName = docName == null || docName.equals("UnknownDocument") ? "doc" + this.iv_procCount + ".xml" : docName + ".xml";
        OutputStream out = null;
        try {
            File outputDir = new File(this.iv_outputDir);
            outputDir.mkdirs();
            File outputFile = new File(this.iv_outputDir + File.separatorChar + docName);
            out = new FileOutputStream(outputFile);
            XCASSerializer.serialize((CAS)view.getCas(), (OutputStream)out, (boolean)true);
        }
        finally {
            ++this.iv_procCount;
            if (out != null) {
                out.close();
            }
        }
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        this.iv_logger.info((Object)"Started");
        try {
            JCas currentView = cas.getCurrentView().getJCas();
            this.processView(currentView);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }
}

