/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.ctakes.core.cc.AbstractJCasFileWriter;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.RelationArgumentUtil;
import org.apache.ctakes.core.util.annotation.OntologyConceptUtil;
import org.apache.ctakes.core.util.annotation.SemanticTui;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@PipeBitInfo(name="CUI List Writer", description="Writes a list of CUIs, covered text and preferred text to files.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN}, usables={PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX, PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class CuiListFileWriter
extends AbstractJCasFileWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"CuiListFileWriter");

    public void writeFile1(JCas jCas, String outputDir, String documentId, String fileName) throws IOException {
        File file = new File(outputDir, documentId + "_cuis.txt");
        Collection annotations = JCasUtil.select((JCas)jCas, IdentifiedAnnotation.class);
        LOGGER.info((Object)("Writing CUI list to " + file.getPath() + " ..."));
        StringBuilder sb = new StringBuilder();
        for (IdentifiedAnnotation annotation : annotations) {
            String coveredText = annotation.getCoveredText();
            OntologyConceptUtil.getUmlsConceptStream(annotation).map(c -> c.getCui() + " , " + coveredText + (c.getPreferredText() != null ? " , " + c.getPreferredText() : "") + "\r\n").forEach(sb::append);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(sb.toString());
        }
        LOGGER.info((Object)"Finished Writing");
    }

    @Override
    public void writeFile(JCas jCas, String outputDir, String documentId, String fileName) throws IOException {
        File file = new File(outputDir, documentId + "_annotationInfo.bsv");
        LOGGER.info((Object)("Writing Annotation Information to " + file.getPath() + " ..."));
        Collection annotations = JCasUtil.select((JCas)jCas, IdentifiedAnnotation.class);
        Collection locations = JCasUtil.select((JCas)jCas, LocationOfTextRelation.class);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write("CUI | Concept | Semantic Group | Negated | Family History | Location | Document Text\n");
            for (IdentifiedAnnotation annotation : annotations) {
                writer.write(CuiListFileWriter.createBsvLines(annotation, locations));
            }
        }
        LOGGER.info((Object)"Finished Writing");
    }

    private static String createBsvLines(IdentifiedAnnotation annotation, Collection<LocationOfTextRelation> locationRelations) {
        String locationCuis = RelationArgumentUtil.getAllRelated(locationRelations, annotation).stream().map(OntologyConceptUtil::getCuis).flatMap(Collection::stream).collect(Collectors.joining(";"));
        return OntologyConceptUtil.getUmlsConceptStream(annotation).map(c -> CuiListFileWriter.createBsvLine(annotation, c, locationCuis)).collect(Collectors.joining("\n"));
    }

    private static String createBsvLine(IdentifiedAnnotation annotation, UmlsConcept concept, String locationCuis) {
        StringBuilder sb = new StringBuilder();
        sb.append(concept.getCode()).append('|').append(concept.getPreferredText()).append('|').append(SemanticTui.getTuiFromCode(concept.getTui()).getGroupName()).append('|').append(annotation.getPolarity() == -1 ? "true" : "false").append('|').append(annotation.getSubject().equals("family_member") ? "true" : "false").append('|').append(locationCuis).append('|').append(annotation.getCoveredText());
        return sb.toString();
    }
}

