/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.ctakes.core.cc.AbstractJCasFileWriter;
import org.apache.ctakes.core.util.annotation.OntologyConceptUtil;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class CuiLookupLister
extends AbstractJCasFileWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"CuiLookupLister");

    @Override
    public void writeFile(JCas jCas, String outputDir, String documentId, String fileName) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputDir + "/" + documentId + "_cui.txt"));){
            Map sentenceCodes = JCasUtil.indexCovered((JCas)jCas, Sentence.class, IdentifiedAnnotation.class);
            for (Map.Entry entry : sentenceCodes.entrySet()) {
                int sentenceBegin = ((Sentence)entry.getKey()).getBegin();
                int sentenceEnd = ((Sentence)entry.getKey()).getEnd();
                for (IdentifiedAnnotation annotation : (Collection)entry.getValue()) {
                    if (annotation.getBegin() < sentenceBegin || annotation.getEnd() > sentenceEnd) continue;
                    for (UmlsConcept umls : OntologyConceptUtil.getUmlsConcepts(annotation)) {
                        writer.write(umls.getCui() + '|' + umls.getTui() + '|' + annotation.getCoveredText() + '\n');
                    }
                }
            }
        }
    }
}

