/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ctakes.core.cc.AbstractTableFileWriter;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.annotation.IdentifiedAnnotationUtil;
import org.apache.ctakes.typesystem.type.refsem.Attribute;
import org.apache.ctakes.typesystem.type.refsem.MedicationDosage;
import org.apache.ctakes.typesystem.type.refsem.MedicationDuration;
import org.apache.ctakes.typesystem.type.refsem.MedicationForm;
import org.apache.ctakes.typesystem.type.refsem.MedicationFrequency;
import org.apache.ctakes.typesystem.type.refsem.MedicationRoute;
import org.apache.ctakes.typesystem.type.refsem.MedicationStrength;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.MedicationDosageModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationDurationModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationFormModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationFrequencyModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationMention;
import org.apache.ctakes.typesystem.type.textsem.MedicationRouteModifier;
import org.apache.ctakes.typesystem.type.textsem.MedicationStrengthModifier;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="Medication Table Writer", description="Writes a table of Medication information to file, sorted by character index.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, usables={PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX})
public class MedicationTableFileWriter
extends AbstractTableFileWriter {
    @Override
    protected List<String> createHeaderRow(JCas jCas) {
        return Arrays.asList(" Preferred Text ", " Document Text ", " Strength ", " Dose ", " Form ", " Route ", " Frequency ", " Duration ");
    }

    @Override
    protected List<List<String>> createDataRows(JCas jCas) {
        return JCasUtil.select((JCas)jCas, MedicationMention.class).stream().sorted(Comparator.comparingInt(Annotation::getBegin)).map(x$0 -> new ModifierRow((MedicationMention)x$0)).map(ModifierRow::getColumns).collect(Collectors.toList());
    }

    private static class ModifierRow {
        private final String _prefText;
        private final String _docText;
        private final String _strength;
        private final String _dose;
        private final String _form;
        private final String _route;
        private final String _frequency;
        private final String _duration;

        private ModifierRow(MedicationMention med) {
            Attribute duration;
            Attribute frequency;
            Attribute route;
            Attribute form;
            Attribute dose;
            Attribute strength;
            this._prefText = IdentifiedAnnotationUtil.getPreferredTexts((IdentifiedAnnotation)med).stream().sorted().collect(Collectors.joining(";"));
            this._docText = med.getCoveredText();
            MedicationStrengthModifier strengthMod = med.getMedicationStrength();
            this._strength = strengthMod == null ? "" : ((strength = strengthMod.getNormalizedForm()) instanceof MedicationStrength ? ((MedicationStrength)strength).getNumber() + " " + ((MedicationStrength)strength).getUnit() : "");
            MedicationDosageModifier doseMod = med.getMedicationDosage();
            this._dose = doseMod == null ? "" : ((dose = doseMod.getNormalizedForm()) instanceof MedicationDosage ? ((MedicationDosage)dose).getValue() : "");
            MedicationFormModifier formMod = med.getMedicationForm();
            this._form = formMod == null ? "" : ((form = formMod.getNormalizedForm()) instanceof MedicationForm ? ((MedicationForm)form).getValue() : "");
            MedicationRouteModifier routeMod = med.getMedicationRoute();
            this._route = routeMod == null ? "" : ((route = routeMod.getNormalizedForm()) instanceof MedicationRoute ? ((MedicationRoute)route).getValue() : "");
            MedicationFrequencyModifier freqMod = med.getMedicationFrequency();
            this._frequency = freqMod == null ? "" : ((frequency = freqMod.getNormalizedForm()) instanceof MedicationFrequency ? ((MedicationFrequency)frequency).getNumber() + " " + ((MedicationFrequency)frequency).getUnit() : "");
            MedicationDurationModifier durationMod = med.getMedicationDuration();
            this._duration = durationMod == null ? "" : ((duration = durationMod.getNormalizedForm()) instanceof MedicationDuration ? ((MedicationDuration)duration).getValue() : "");
        }

        public List<String> getColumns() {
            return Arrays.asList(this._prefText, this._docText, this._strength, this._dose, this._form, this._route, this._frequency.replace(" null", ""), this._duration);
        }
    }
}

