/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ctakes.core.cc.AbstractTableFileWriter;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.annotation.IdentifiedAnnotationUtil;
import org.apache.ctakes.core.util.annotation.SemanticTui;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.log4j.Logger;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@PipeBitInfo(name="Semantic Table Writer", description="Writes a table of Annotation information to file, grouped by Semantic Type.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, usables={PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX})
public class SemanticTableFileWriter
extends AbstractTableFileWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"SemanticTableFileWriter");

    @Override
    protected List<String> createHeaderRow(JCas jCas) {
        return Arrays.asList(" Semantic Group ", " Semantic Type ", " Section ", " Span ", " Negated ", " Uncertain ", " Generic ", " CUI ", " Preferred Text ", " Document Text ");
    }

    @Override
    protected List<List<String>> createDataRows(JCas jCas) {
        ArrayList<AnnotationInfo> infos = new ArrayList<AnnotationInfo>();
        Map eventSectionMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, Segment.class);
        for (EventMention annotation : eventSectionMap.keySet()) {
            Collection<SemanticTui> tuis = SemanticTui.getTuis((IdentifiedAnnotation)annotation);
            for (SemanticTui tui : tuis) {
                infos.add(new AnnotationInfo(tui, (Collection)eventSectionMap.get(annotation), (IdentifiedAnnotation)annotation));
            }
        }
        Map siteSectionMap = JCasUtil.indexCovering((JCas)jCas, AnatomicalSiteMention.class, Segment.class);
        for (AnatomicalSiteMention annotation : siteSectionMap.keySet()) {
            Collection<SemanticTui> tuis = SemanticTui.getTuis((IdentifiedAnnotation)annotation);
            for (SemanticTui tui : tuis) {
                infos.add(new AnnotationInfo(tui, (Collection)siteSectionMap.get(annotation), (IdentifiedAnnotation)annotation));
            }
        }
        return infos.stream().sorted(Comparator.comparingInt(AnnotationInfo::getBegin).thenComparingInt(AnnotationInfo::getEnd).thenComparing(AnnotationInfo::getGroup).thenComparing(AnnotationInfo::getTui).thenComparing(AnnotationInfo::getSection).thenComparing(AnnotationInfo::isNegated).thenComparing(AnnotationInfo::isUncertain).thenComparing(AnnotationInfo::isGeneric).thenComparing(AnnotationInfo::getCui).thenComparing(AnnotationInfo::getPrefText).thenComparing(AnnotationInfo::getDocText)).map(AnnotationInfo::getColumns).collect(Collectors.toList());
    }

    private static class AnnotationInfo {
        private final String _group;
        private final int _begin;
        private final int _end;
        private final String _tui;
        private final String _section;
        private final String _cui;
        private final boolean _negated;
        private final boolean _uncertain;
        private final boolean _generic;
        private final String _prefText;
        private final String _docText;

        private AnnotationInfo(SemanticTui tui, Collection<Segment> section, IdentifiedAnnotation annotation) {
            this._group = tui.getGroup().getName();
            this._begin = annotation.getBegin();
            this._end = annotation.getEnd();
            this._tui = tui.getSemanticType();
            String sectionText = section == null || section.isEmpty() ? "NULL" : new ArrayList<Segment>(section).get(0).getPreferredText();
            this._section = sectionText == null ? "NULL" : sectionText;
            this._cui = IdentifiedAnnotationUtil.getCuis(annotation).stream().sorted().collect(Collectors.joining(";"));
            this._negated = IdentifiedAnnotationUtil.isNegated(annotation);
            this._uncertain = IdentifiedAnnotationUtil.isUncertain(annotation);
            this._generic = IdentifiedAnnotationUtil.isGeneric(annotation);
            this._prefText = IdentifiedAnnotationUtil.getPreferredTexts(annotation).stream().sorted().collect(Collectors.joining(";"));
            this._docText = annotation.getCoveredText();
        }

        public List<String> getColumns() {
            return Arrays.asList(this.getGroup(), this.getTui(), this.getSection(), this.getBegin() + "," + this.getEnd(), this.isNegated() + "", this.isUncertain() + "", this.isGeneric() + "", this.getCui(), this.getPrefText(), this.getDocText());
        }

        public String getGroup() {
            return this._group;
        }

        public String getTui() {
            return this._tui;
        }

        public String getSection() {
            return this._section;
        }

        public int getBegin() {
            return this._begin;
        }

        public int getEnd() {
            return this._end;
        }

        public String getCui() {
            return this._cui;
        }

        public boolean isNegated() {
            return this._negated;
        }

        public boolean isUncertain() {
            return this._uncertain;
        }

        public boolean isGeneric() {
            return this._generic;
        }

        public String getPrefText() {
            return this._prefText;
        }

        public String getDocText() {
            return this._docText;
        }
    }
}

