/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.JCasUtil;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

@PipeBitInfo(name="Sentences Writer", description="Writes Text files with original text from the document, sentence by sentence.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN})
@Deprecated
public class SentenceTokensPrinter
extends CasConsumer_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"SentenceTokensPrinter");
    private String _outputDirPath;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        String outputDirPath = (String)this.getConfigParameterValue("OutputDirectory");
        if (outputDirPath != null && !outputDirPath.isEmpty()) {
            File outputDirectory = new File(outputDirPath);
            if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
                throw new ResourceInitializationException((Throwable)new IOException("Parameter setting OutputDirectory does not point to an existing directory or one that could be created."));
            }
            this._outputDirPath = outputDirPath;
        }
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = cas.getJCas();
        }
        catch (CASException casE) {
            LOGGER.error((Object)casE.getMessage());
            return;
        }
        int sentenceTypeCode = JCasUtil.getType("org.apache.ctakes.typesystem.type.textspan.Sentence");
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        AnnotationIndex sentences = indexes.getAnnotationIndex(sentenceTypeCode);
        if (sentences == null) {
            return;
        }
        ArrayList<String> tokenizedSentences = new ArrayList<String>(sentences.size());
        try {
            for (Object sentence : sentences) {
                tokenizedSentences.add(SentenceTokensPrinter.getSentenceTokens(jcas, (Annotation)sentence));
            }
        }
        catch (ArrayIndexOutOfBoundsException iobE) {
            LOGGER.warn((Object)iobE.getMessage());
        }
        String documentId = DocIdUtil.getDocumentID(jcas);
        this.outputSentenceTokens(documentId, tokenizedSentences);
    }

    private static String getSentenceTokens(JCas jcas, Annotation sentence) {
        StringBuilder sb = new StringBuilder();
        List allBaseTokens = org.apache.uima.fit.util.JCasUtil.selectCovered((JCas)jcas, BaseToken.class, (AnnotationFS)sentence);
        for (BaseToken baseToken : allBaseTokens) {
            if (baseToken instanceof NewlineToken) continue;
            sb.append(baseToken.getCoveredText()).append(' ');
        }
        return sb.toString();
    }

    private void outputSentenceTokens(String documentId, Iterable<String> tokenizedSentences) {
        if (this._outputDirPath == null) {
            SentenceTokensPrinter.printSentenceTokens(documentId, tokenizedSentences);
        } else {
            SentenceTokensPrinter.saveSentenceTokens(this._outputDirPath, documentId, tokenizedSentences);
        }
    }

    private static void printSentenceTokens(String documentId, Iterable<String> tokenizedSentences) {
        System.out.println("===========================   " + documentId + "   ===========================");
        for (String tokenizedSentence : tokenizedSentences) {
            System.out.println(tokenizedSentence);
        }
    }

    private static void saveSentenceTokens(String outputDirPath, String documentId, Iterable<String> tokenizedSentences) {
        File outputFile = new File(outputDirPath + File.pathSeparator + documentId);
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            LOGGER.error((Object)(outputFile.getPath() + " is an invalid output file path"));
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            for (String tokenizedSentence : tokenizedSentences) {
                writer.write(tokenizedSentence);
                writer.newLine();
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)ioE.getMessage());
        }
    }
}

