/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.typesystem.type.refsem.Entity;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.CasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Text Span Writer", description="Writes BSV files with original text for extracted annotations and their span offsets.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class TextSpanWriter
extends CasConsumer_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"TextSpanWriter");
    private static final String FILE_EXTENSION = ".textspan.bsv";
    @ConfigurationParameter(name="OutputDirectory", mandatory=false, description="Directory for all output files.", defaultValue={""})
    private String fitOutputDirectoryPath;
    private String _outputDirPath;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        try {
            if (this.fitOutputDirectoryPath == null) {
                this.fitOutputDirectoryPath = (String)uimaContext.getConfigParameterValue("OutputDirectory");
            }
            if (this.fitOutputDirectoryPath != null) {
                this.setOutputDirectory(this.fitOutputDirectoryPath);
            }
        }
        catch (IllegalArgumentException | SecurityException multE) {
            throw new ResourceInitializationException((Throwable)multE);
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException casE) {
            throw new AnalysisEngineProcessException((Throwable)casE);
        }
        this.process(jcas);
    }

    public void setOutputDirectory(String outputDirectoryPath) throws IllegalArgumentException, SecurityException {
        if (outputDirectoryPath == null || outputDirectoryPath.isEmpty()) {
            this._outputDirPath = "";
            LOGGER.debug((Object)("No Output Directory Path specified, using current working directory " + System.getProperty("user.dir")));
            return;
        }
        File outputDir = new File(outputDirectoryPath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException(outputDirectoryPath + " is not a valid directory path");
        }
        this._outputDirPath = outputDirectoryPath;
        LOGGER.debug((Object)("Output Directory Path set to " + this._outputDirPath));
    }

    public void process(JCas jcas) {
        LOGGER.info((Object)"Starting processing");
        String docId = DocIdUtil.getDocumentIdForFile(jcas);
        File outputFile = this._outputDirPath == null || this._outputDirPath.isEmpty() ? new File(docId + FILE_EXTENSION) : new File(this._outputDirPath, docId + FILE_EXTENSION);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            Collection annotations = JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class);
            for (IdentifiedAnnotation annotation : annotations) {
                TextSpanWriter.writeAnnotation((AnnotationFS)annotation, writer);
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Could not not write text span file " + outputFile.getPath()));
            LOGGER.error((Object)ioE.getMessage());
        }
        LOGGER.info((Object)"Finished processing");
    }

    public static void writeAnnotation(AnnotationFS annotation, Writer writer) throws IOException {
        if (!(annotation instanceof Event) && !(annotation instanceof Entity)) {
            return;
        }
        writer.write(annotation.getClass().getName() + "|" + annotation.getBegin() + "," + annotation.getEnd() + "|" + annotation.getCoveredText());
        writer.write("\n");
    }
}

