/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ctakes.core.cc.AbstractTableFileWriter;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@PipeBitInfo(name="Token Table Writer", description="Writes a table of base tokens and their spans in a directory tree.", role=PipeBitInfo.Role.WRITER, usables={PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX, PipeBitInfo.TypeProduct.BASE_TOKEN})
public final class TokenTableFileWriter
extends AbstractTableFileWriter {
    @Override
    protected List<String> createHeaderRow(JCas jCas) {
        return Arrays.asList(" Token Text ", " Text Span ");
    }

    @Override
    protected List<List<String>> createDataRows(JCas jCas) {
        ArrayList<List<String>> dataRows = new ArrayList<List<String>>();
        String docText = jCas.getDocumentText();
        for (BaseToken token : JCasUtil.select((JCas)jCas, BaseToken.class)) {
            int begin = token.getBegin();
            int end = token.getEnd();
            String text = token instanceof NewlineToken ? "<EOL>" : docText.substring(begin, end);
            dataRows.add(Arrays.asList(text, begin + "," + end));
        }
        return dataRows;
    }
}

