/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.fit.component.CasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.UriUtils;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.cleartk.util.ViewUriUtil;
import org.xml.sax.SAXException;

@PipeBitInfo(name="XMI Writer", description="Writes XMI files with full representation of input text and all extracted information.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID})
@Deprecated
public class XmiWriterCasConsumerCtakes
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    @ConfigurationParameter(name="OutputDirectory", description="Output directory to write xmi files", mandatory=true)
    private File mOutputDir;
    private int mDocNum;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        Logger.getLogger((String)((Object)((Object)this)).getClass().getSimpleName()).warn((Object)"Deprecated.  Please use FileTreeXmiWriter instead.");
        this.mDocNum = 0;
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        File inFile;
        URI uri;
        String outFileName;
        JCas jcas;
        String modelFileName = null;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e1) {
            e1.printStackTrace();
            throw new AnalysisEngineProcessException((Throwable)e1);
        }
        String originalFileName = DocIdUtil.getDocumentID(jcas);
        File outFile = null;
        if (originalFileName != null && !originalFileName.isEmpty() && !originalFileName.equals("UnknownDocument")) {
            try {
                outFileName = null;
                if (originalFileName.contains("/")) {
                    uri = UriUtils.quote((String)originalFileName);
                    inFile = new File(uri);
                    outFileName = inFile.getName();
                } else {
                    outFileName = originalFileName;
                }
                outFileName = outFileName + ".xmi";
                outFile = new File(this.mOutputDir, outFileName);
            }
            catch (URISyntaxException outFileName2) {
                // empty catch block
            }
        }
        if (outFile == null) {
            originalFileName = ViewUriUtil.getURI((JCas)jcas).toString();
            outFileName = null;
            if (originalFileName != null && !originalFileName.isEmpty() && !originalFileName.equals("UnknownDocument")) {
                try {
                    if (originalFileName.contains("/")) {
                        uri = UriUtils.quote((String)originalFileName);
                        inFile = new File(uri);
                        outFileName = inFile.getName();
                    } else {
                        outFileName = originalFileName;
                    }
                    outFileName = outFileName + ".xmi";
                    outFile = new File(this.mOutputDir, outFileName);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        if (outFile == null) {
            outFile = new File(this.mOutputDir, "doc" + this.mDocNum++ + ".xmi");
        }
        try {
            this.writeXmi(jcas.getCas(), outFile, modelFileName);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (SAXException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmi(CAS aCas, File name) throws IOException, SAXException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmi(CAS aCas, File name, String modelFileName) throws IOException, SAXException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    public static CasConsumerDescription getDescription() throws InvalidXMLException {
        InputStream descStream = XmiWriterCasConsumerCtakes.class.getResourceAsStream("XmiWriterCasConsumerCtakes.xml");
        return UIMAFramework.getXMLParser().parseCasConsumerDescription(new XMLInputSource(descStream, null));
    }

    public static URL getDescriptorURL() {
        return XmiWriterCasConsumerCtakes.class.getResource("XmiWriterCasConsumerCtakes.xml");
    }
}

