/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.html;

import org.apache.ctakes.core.util.annotation.SemanticGroup;

public enum SemanticMarkup {
    DRUG_MARK(SemanticGroup.DRUG, "_DRG_", "Red", "25B3"),
    DISORDER_MARK(SemanticGroup.DISORDER, "_DIS_", "Black", "25BD"),
    FINDING_MARK(SemanticGroup.FINDING, "_FND_", "Magenta", "2022"),
    PROCEDURE_MARK(SemanticGroup.PROCEDURE, "_PRC_", "Blue", "25C6"),
    ANATOMY_MARK(SemanticGroup.ANATOMY, "_ANT_", "Gray", "25C9"),
    CLINICAL_ATTRIBUTE_MARK(SemanticGroup.CLINICAL_ATTRIBUTE, "_ATT_", "Gray", "25FE"),
    DEVICE_MARK(SemanticGroup.DEVICE, "_DEV_", "Blue", "2600"),
    LAB_MARK(SemanticGroup.LAB, "_LAB_", "Gray", "2714"),
    PHENOMENON_MARK(SemanticGroup.PHENOMENON, "_PHN_", "Magenta", "2604"),
    SUBJECT_MARK(SemanticGroup.SUBJECT, "_SBJ_", "CadetBlue", "2605"),
    TITLE_MARK(SemanticGroup.TITLE, "_TTL_", "CadetBlue", "2605"),
    EVENT_MARK(SemanticGroup.EVENT, "_EVT_", "DarkSeaGreen", "263C"),
    ENTITY_MARK(SemanticGroup.ENTITY, "_ENT_", "Black", "25FE"),
    TIME_MARK(SemanticGroup.TIME, "_TMX_", "Black", "2742"),
    MODIFIER_MARK(SemanticGroup.MODIFIER, "_MOD_", "Coral", "259F"),
    LAB_MODIFIER_MARK(SemanticGroup.LAB_MODIFIER, "_LABM_", "Coral", "21B7"),
    UNKNOWN_MARK(SemanticGroup.UNKNOWN, "_UNK_", "DarkMagenta", "2753");

    private final SemanticGroup _group;
    private final String _encoding;
    private final String _color;
    private final String _asterisk;

    private SemanticMarkup(SemanticGroup group, String encoding, String color, String asterisk) {
        this._group = group;
        this._encoding = encoding;
        this._color = color;
        this._asterisk = asterisk;
    }

    public SemanticGroup getGroup() {
        return this._group;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public String getColor() {
        return this._color;
    }

    public String getAsterisk() {
        return this._asterisk;
    }

    public static SemanticMarkup getMarkup(SemanticGroup group) {
        for (SemanticMarkup markup : SemanticMarkup.values()) {
            if (markup._group != group) continue;
            return markup;
        }
        return UNKNOWN_MARK;
    }
}

