/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.jdbc;

import java.sql.SQLException;
import java.util.Collection;
import org.apache.ctakes.core.cc.jdbc.db.JdbcDb;
import org.apache.ctakes.core.cc.jdbc.table.JdbcTable;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public abstract class AbstractJdbcWriter<T>
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"AstractJdbcWriter");
    public static final String PARAM_DB_DRIVER = "DbDriver";
    @ConfigurationParameter(name="DbDriver", description="JDBC driver ClassName.")
    private String _dbDriver;
    public static final String PARAM_DB_URL = "DbUrl";
    @ConfigurationParameter(name="DbUrl", description="JDBC URL that specifies database network location and name.")
    private String _url;
    public static final String PARAM_DB_USER = "DbUser";
    @ConfigurationParameter(name="DbUser", description="Username for database authentication.")
    private String _user;
    public static final String PARAM_DB_PASS = "DbPass";
    @ConfigurationParameter(name="DbPass", description="Password for database authentication.")
    private String _pass;
    public static final String PARAM_KEEP_ALIVE = "KeepAlive";
    @ConfigurationParameter(name="KeepAlive", description="Flag that determines whether to keep JDBC connection open no matter what.", mandatory=false)
    private String _keepAlive;
    public static final String PARAM_BATCH_SIZE = "BatchSize";
    @ConfigurationParameter(name="BatchSize", description="Number of statements to use in a batch.  0 or 1 denotes that batches should not be used.", mandatory=false)
    private String _batchSize;
    private static final int MAX_BATCH_SIZE = 256;
    private static final Object DATA_LOCK = new Object();
    private JdbcDb _jdbcDb;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this._jdbcDb = this.createJdbcDb(this._dbDriver, this._url, this._user, this._pass, this._keepAlive);
        if (this._batchSize != null && !this._batchSize.trim().isEmpty()) {
            try {
                int batchSize = Integer.decode(this._batchSize.trim());
                this._jdbcDb.setBatchSize(batchSize);
            }
            catch (NumberFormatException nfE) {
                LOGGER.error((Object)("Could not parse batch size " + this._batchSize));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        try {
            Object object = DATA_LOCK;
            synchronized (object) {
                this.createData(jcas);
                T data = this.getData();
                if (data != null) {
                    this.writeJdbc(data);
                    this.writeComplete(data);
                }
            }
        }
        catch (SQLException sqlE) {
            throw new AnalysisEngineProcessException((Throwable)sqlE);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        try {
            this._jdbcDb.close();
        }
        catch (SQLException sqlE) {
            LOGGER.error((Object)sqlE.getMessage());
        }
    }

    protected abstract JdbcDb createJdbcDb(String var1, String var2, String var3, String var4, String var5) throws ResourceInitializationException;

    protected abstract void createData(JCas var1);

    protected abstract T getData();

    protected abstract void writeComplete(T var1);

    public void writeJdbc(T data) throws SQLException {
        for (JdbcTable<?> table : this.getJdbcTables(data.getClass())) {
            table.writeValue(data);
        }
    }

    private Collection<JdbcTable<T>> getJdbcTables(Class<T> dataClass) {
        return this._jdbcDb.getTables(dataClass);
    }
}

