/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.jdbc.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ctakes.core.cc.jdbc.db.JdbcDb;
import org.apache.ctakes.core.cc.jdbc.table.JdbcTable;
import org.apache.uima.resource.ResourceInitializationException;
import sqlWrapper.WrappedConnection;

public abstract class AbstractJdbcDb
implements JdbcDb {
    private final Connection _connection;
    private final Collection<JdbcTable<?>> _jdbcTables = new ArrayList();

    public AbstractJdbcDb(String driver, String url, String user, String pass, String keepAlive) throws ResourceInitializationException {
        this._connection = AbstractJdbcDb.createConnection(driver, url, user, pass, keepAlive);
    }

    private static Connection createConnection(String driver, String url, String user, String pass, String keepAlive) throws ResourceInitializationException {
        Object[] emptyObjectArray = new Object[]{};
        try {
            if (keepAlive != null && !keepAlive.isEmpty() && Boolean.valueOf(keepAlive).booleanValue()) {
                return new WrappedConnection(user, pass, driver, url);
            }
            Class<?> driverClass = Class.forName(driver);
            return DriverManager.getConnection(url, user, pass);
        }
        catch (ClassNotFoundException | SQLException multE) {
            throw new ResourceInitializationException("Could not construct " + driver, emptyObjectArray, (Throwable)multE);
        }
    }

    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public final void addTable(JdbcTable<?> table) {
        this._jdbcTables.add(table);
    }

    @Override
    public final Collection<JdbcTable<?>> getTables() {
        return this._jdbcTables;
    }
}

