/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.jdbc.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ctakes.core.cc.jdbc.table.JdbcTable;

public interface JdbcDb {
    public void addTable(JdbcTable<?> var1);

    public Collection<JdbcTable<?>> getTables();

    default public <T> Collection<JdbcTable<T>> getTables(Class<T> dataClass) {
        ArrayList<JdbcTable<T>> tables = new ArrayList<JdbcTable<T>>();
        for (JdbcTable<?> table : this.getTables()) {
            Class<T> dataType = table.getDataType();
            if (dataType == null || !dataType.isAssignableFrom(dataClass)) continue;
            tables.add(table);
        }
        return tables;
    }

    default public void setBatchSize(int batchSize) {
        for (JdbcTable<?> table : this.getTables()) {
            table.setBatchSize(batchSize);
        }
    }

    default public void close() throws SQLException {
        for (JdbcTable<?> table : this.getTables()) {
            table.close();
        }
    }
}

