/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.jdbc.i2b2;

import java.sql.SQLException;
import org.apache.ctakes.core.cc.jdbc.AbstractJCasJdbcWriter;
import org.apache.ctakes.core.cc.jdbc.db.JdbcDb;
import org.apache.ctakes.core.cc.jdbc.i2b2.I2b2Db;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="I2b2JdbcWriter", description="Writes UMLS Concepts to a standard I2B2 Observation_Fact table.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class I2b2JdbcWriter
extends AbstractJCasJdbcWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"I2b2JdbcWriter");
    public static final String PARAM_TABLE_NAME = "FactOutputTable";
    @ConfigurationParameter(name="FactOutputTable", description="Name of the Observation_Fact table for writing output.")
    private String _tableName;
    public static final String PARAM_REPEAT_CUIS = "RepeatCuis";
    @ConfigurationParameter(name="RepeatCuis", description="Repeat Concepts with the same Cui but possibly different Semantic Type or Preferred Text.", mandatory=false)
    private boolean _repeatCuis;

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        LOGGER.info((Object)"Writing to Database ...");
        super.process(jcas);
    }

    protected final String getTableName() {
        return this._tableName;
    }

    protected final boolean isRepeatCuis() {
        return this._repeatCuis;
    }

    @Override
    protected JdbcDb createJdbcDb(String driver, String url, String user, String pass, String keepAlive) throws ResourceInitializationException {
        LOGGER.info((Object)("Initializing connection to " + url + " ..."));
        I2b2Db db = new I2b2Db(driver, url, user, pass, keepAlive);
        try {
            db.addObservationFact(this.getTableName(), this.isRepeatCuis());
        }
        catch (SQLException sqlE) {
            throw new ResourceInitializationException((Throwable)sqlE);
        }
        return db;
    }
}

