/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.jdbc.i2b2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ctakes.core.cc.jdbc.field.IntField;
import org.apache.ctakes.core.cc.jdbc.field.JdbcField;
import org.apache.ctakes.core.cc.jdbc.field.LongField;
import org.apache.ctakes.core.cc.jdbc.field.TextField;
import org.apache.ctakes.core.cc.jdbc.field.TimeField;
import org.apache.ctakes.core.cc.jdbc.i2b2.ObservationFactTable;
import org.apache.ctakes.core.cc.jdbc.row.JdbcRow;
import org.apache.ctakes.core.util.doc.SourceMetadataUtil;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.structured.SourceData;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceProcessException;

public class ObservationFactRow
implements JdbcRow<ObservationFactTable.CorpusSettings, JCas, JCas, IdentifiedAnnotation, UmlsConcept> {
    private static final Logger LOGGER = Logger.getLogger((String)"ObservationFactRow");
    private static final String PATIENT_NUM = "patient_num";
    private static final String PROVIDER_ID = "provider_id";
    private static final String ENCOUNTER_NUM = "encounter_num";
    private static final String START_DATE = "start_date";
    private static final String INSTANCE_NUM = "instance_num";
    private static final String CONCEPT_CD = "concept_cd";
    private static final String MODIFIER_CD = "modifier_cd";
    private static final String VALTYPE_CD = "valtype_cd";
    private static final String TVAL_CHAR = "tval_char";
    private static final String OBSERVATION_BLOB = "observation_blob";
    private static final String DEFAULT_MODIFIER_CD = "@";
    private static final String DEFAULT_VALTYPE_CD = "T";
    private static final String NEGATED_MARK = "-";
    private static final String UNCERTAIN_MARK = "~";
    private static final String GENERIC_MARK = "*";
    private static final String NO_MARK = "";
    private final LongField _patientNum = new LongField("patient_num", 1);
    private final TextField _providerId = new TextField("provider_id", 2);
    private final IntField _encounterNum = new IntField("encounter_num", 3);
    private final TimeField _startDate = new TimeField("start_date", 4);
    private final LongField _instanceNum = new LongField("instance_num", 5);
    private final TextField _conceptCd = new TextField("concept_cd", 6);
    private final TextField _modifierCd = new TextField("modifier_cd", 7);
    private final TextField _valtypeCd = new TextField("valtype_cd", 8);
    private final TextField _tvalChar = new TextField("tval_char", 9);
    private final TextField _observationBlob = new TextField("observation_blob", 10);
    private long _patient;
    private String _provider;
    private int _encounter;
    private Timestamp _start;
    private long _instance;
    private String _negatedMark;
    private String _uncertainMark;
    private String _genericMark;
    private String _conceptPrefix;
    private IdentifiedAnnotation _annotation;

    @Override
    public Collection<JdbcField<?>> getFields() {
        return Arrays.asList(this._patientNum, this._providerId, this._encounterNum, this._startDate, this._instanceNum, this._conceptCd, this._modifierCd, this._valtypeCd, this._tvalChar, this._observationBlob);
    }

    @Override
    public void initializeCorpus(ObservationFactTable.CorpusSettings corpusValue) {
        this._negatedMark = corpusValue.markNegated() ? NEGATED_MARK : NO_MARK;
        this._uncertainMark = corpusValue.markUncertain() ? UNCERTAIN_MARK : NO_MARK;
        this._genericMark = corpusValue.markGeneric() ? GENERIC_MARK : NO_MARK;
    }

    @Override
    public void initializePatient(JCas patientValue) {
        this._patient = SourceMetadataUtil.getPatientNum(patientValue);
    }

    @Override
    public void initializeDocument(JCas documentValue) {
        this._instance = 1L;
        SourceData sourceData = SourceMetadataUtil.getSourceData(documentValue);
        if (sourceData == null) {
            LOGGER.warn((Object)"No document source data.");
            this.setEmptyDocInfo();
            return;
        }
        try {
            this._encounter = SourceMetadataUtil.getEncounterNum(sourceData);
            this._provider = SourceMetadataUtil.getProviderId(sourceData);
            this._start = SourceMetadataUtil.getStartDate(sourceData);
        }
        catch (ResourceProcessException rpE) {
            LOGGER.warn((Object)("Error setting document source data: " + rpE.getMessage()));
            this.setEmptyDocInfo();
        }
    }

    @Override
    public void initializeEntity(IdentifiedAnnotation entityValue) {
        this._annotation = entityValue;
        this._conceptPrefix = NO_MARK + (this._annotation.getPolarity() == -1 ? this._negatedMark : NO_MARK) + (this._annotation.getUncertainty() == 1 ? this._uncertainMark : NO_MARK) + (this._annotation.getGeneric() ? this._genericMark : NO_MARK);
    }

    @Override
    public void addToStatement(PreparedStatement statement, UmlsConcept value) throws SQLException {
        this._patientNum.addToStatement(statement, this._patient);
        this._providerId.addToStatement(statement, this._provider);
        this._encounterNum.addToStatement(statement, this._encounter);
        this._startDate.addToStatement(statement, this._start);
        this._instanceNum.addToStatement(statement, this._instance);
        this._conceptCd.addToStatement(statement, this.getConceptCode(value));
        this._modifierCd.addToStatement(statement, this.getModifierCd(value));
        this._valtypeCd.addToStatement(statement, this.getValtypeCd(value));
        this._tvalChar.addToStatement(statement, this.getTvalChar(value));
        this._observationBlob.addToStatement(statement, this.getObservationBlob(value));
        ++this._instance;
    }

    protected void setEmptyDocInfo() {
        this._encounter = -1;
        this._provider = NO_MARK;
        this._start = Timestamp.valueOf(LocalDateTime.now());
    }

    private String getConceptCode(UmlsConcept concept) {
        return this._conceptPrefix + concept.getCui();
    }

    private String getModifierCd(UmlsConcept concept) {
        return DEFAULT_MODIFIER_CD;
    }

    private String getValtypeCd(UmlsConcept concept) {
        return DEFAULT_VALTYPE_CD;
    }

    private String getTvalChar(UmlsConcept concept) {
        return concept.getPreferredText();
    }

    protected String getObservationBlob(UmlsConcept concept) {
        return NO_MARK;
    }
}

