/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.jdbc.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ctakes.core.cc.jdbc.table.JdbcTable;

@NotThreadSafe
public abstract class AbstractJdbcTable<T>
implements JdbcTable<T> {
    private static final int DEFAULT_BATCH_LIMIT = 256;
    private final String _tableName;
    private final PreparedStatement _preparedStatement;
    private int _batchSize = 256;
    private int _batchIndex = 0;

    public AbstractJdbcTable(Connection connection, String tableName) throws SQLException {
        this._tableName = tableName;
        String sql = this.createRowInsertSql();
        this._preparedStatement = connection.prepareStatement(sql);
    }

    @Override
    public final String getTableName() {
        return this._tableName;
    }

    @Override
    public final PreparedStatement getPreparedStatement() {
        return this._preparedStatement;
    }

    @Override
    public final void setBatchSize(int batchSize) {
        if (batchSize >= 0 && batchSize <= 10000) {
            this._batchSize = batchSize;
        }
    }

    @Override
    public final int getBatchSize() {
        return this._batchSize;
    }

    protected boolean writeRow() throws SQLException {
        PreparedStatement statement = this.getPreparedStatement();
        if (this._batchSize < 2) {
            statement.execute();
            return true;
        }
        statement.addBatch();
        ++this._batchIndex;
        if (this._batchIndex >= this._batchSize) {
            this._batchIndex = 0;
            statement.executeBatch();
            statement.clearBatch();
            return true;
        }
        return false;
    }
}

