/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.jdbc.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.ctakes.core.cc.jdbc.row.JdbcRow;
import org.apache.ctakes.core.cc.jdbc.table.AbstractJdbcTable;
import org.apache.ctakes.core.util.annotation.OntologyConceptUtil;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public abstract class AbstractUmlsTable<C>
extends AbstractJdbcTable<JCas> {
    private JdbcRow<C, JCas, JCas, IdentifiedAnnotation, UmlsConcept> _jdbcRow;
    private final boolean _repeatCuis;

    public AbstractUmlsTable(Connection connection, String tableName, boolean repeatCuis) throws SQLException {
        super(connection, tableName);
        this._repeatCuis = repeatCuis;
    }

    protected abstract C getCorpusInitializer(JCas var1);

    protected abstract JdbcRow<C, JCas, JCas, IdentifiedAnnotation, UmlsConcept> createJdbcRow();

    @Override
    public final Class<JCas> getDataType() {
        return JCas.class;
    }

    @Override
    public final JdbcRow<C, JCas, JCas, IdentifiedAnnotation, UmlsConcept> getJdbcRow() {
        if (this._jdbcRow == null) {
            this._jdbcRow = this.createJdbcRow();
        }
        return this._jdbcRow;
    }

    @Override
    public final void writeValue(JCas value) throws SQLException {
        PreparedStatement statement = this.getPreparedStatement();
        C corpusInitializer = this.getCorpusInitializer(value);
        JdbcRow<C, JCas, JCas, IdentifiedAnnotation, UmlsConcept> row = this.getJdbcRow();
        row.initializeCorpus(corpusInitializer);
        row.initializePatient(value);
        row.initializeDocument(value);
        ArrayList<UmlsConcept> removals = new ArrayList<UmlsConcept>();
        HashSet<String> cuis = new HashSet<String>();
        boolean batchWritten = false;
        Collection annotations = JCasUtil.select((JCas)value, IdentifiedAnnotation.class);
        if (annotations.isEmpty()) {
            return;
        }
        int rowCount = 0;
        for (IdentifiedAnnotation annotation : annotations) {
            row.initializeEntity(annotation);
            Collection<UmlsConcept> umlsConcepts = OntologyConceptUtil.getUmlsConcepts(annotation);
            if (!this._repeatCuis && umlsConcepts.size() > 1) {
                for (UmlsConcept concept : umlsConcepts) {
                    if (cuis.contains(concept.getCui())) {
                        removals.add(concept);
                    }
                    cuis.add(concept.getCui());
                }
                umlsConcepts.removeAll(removals);
                removals.clear();
                cuis.clear();
            }
            for (UmlsConcept concept : umlsConcepts) {
                row.addToStatement(statement, concept);
                batchWritten = this.writeRow();
                ++rowCount;
            }
        }
        if (!batchWritten && rowCount > 0) {
            statement.executeBatch();
            statement.clearBatch();
        }
    }
}

