/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.jdbc.table;

import java.sql.PreparedStatement;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.apache.ctakes.core.cc.jdbc.field.JdbcField;
import org.apache.ctakes.core.cc.jdbc.row.JdbcRow;

public interface JdbcTable<T> {
    public String getTableName();

    public Class<T> getDataType();

    public JdbcRow<?, ?, ?, ?, ?> getJdbcRow();

    public PreparedStatement getPreparedStatement();

    public void setBatchSize(int var1);

    public int getBatchSize();

    default public Collection<JdbcField<?>> getFields() {
        return this.getJdbcRow().getFields();
    }

    public void writeValue(T var1) throws SQLException;

    default public String createRowInsertSql() throws SQLDataException {
        ArrayList fields = new ArrayList(this.getFields());
        if (fields.isEmpty()) {
            throw new SQLDataException("Must set at least one Field to create an sql insert Statement");
        }
        fields.sort(Comparator.comparingInt(JdbcField::getIndex));
        StringBuilder statement = new StringBuilder("insert into");
        StringBuilder queries = new StringBuilder();
        statement.append(" ").append(this.getTableName());
        statement.append(" (");
        for (JdbcField jdbcField : fields) {
            statement.append(jdbcField.getName()).append(",");
            queries.append("?,");
        }
        statement.setLength(statement.length() - 1);
        queries.setLength(queries.length() - 1);
        statement.append(") values (").append((CharSequence)queries).append(")");
        return statement.toString();
    }

    default public void close() throws SQLException {
        this.getPreparedStatement().close();
    }
}

