/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.ctakes.core.util.annotation.OntologyConceptUtil;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;

public enum SemanticGroup {
    ANATOMICAL_SITE("Anatomy", "ANT", "T021", "T022", "T023", "T024", "T025", "T026", "T029", "T030"),
    DISORDER("Disorder", "DIS", "T019", "T020", "T037", "T047", "T048", "T049", "T050", "T190", "T191"),
    FINDING("Finding", "FND", "T033", "T034", "T040", "T041", "T042", "T043", "T044", "T045", "T046", "T056", "T057", "T184"),
    PROCEDURE("Procedure", "PRC", "T059", "T060", "T061"),
    MEDICATION("Drug", "DRG", "T109", "T110", "T114", "T115", "T116", "T118", "T119", "T121", "T122", "T123", "T124", "T125", "T126", "T127", "T129", "T130", "T131", "T195", "T196", "T197", "T200", "T203");

    public static final String UNKNOWN_SEMANTIC = "Unknown";
    public static final String UNKNOWN_SEMANTIC_CODE = "UNK";
    public static final String EVENT_SEMANTIC = "Event";
    public static final String EVENT_CODE = "EVT";
    public static final String TIMEX_SEMANTIC = "Time";
    public static final String TIMEX_CODE = "TMX";
    public static final String ENTITY_SEMANTIC = "Entity";
    public static final String ENTITY_CODE = "ENT";
    private final String _name;
    private final String _code;
    private final Collection<String> _tuis;

    private SemanticGroup(String name, String code, String ... tuis) {
        this._name = name;
        this._code = code;
        this._tuis = Arrays.asList(tuis);
    }

    public String getName() {
        return this._name;
    }

    public String getCode() {
        return this._code;
    }

    public static Collection<String> getSemanticNames(IdentifiedAnnotation annotation) {
        Collection<UmlsConcept> umlsConcepts = OntologyConceptUtil.getUmlsConcepts(annotation);
        if (umlsConcepts == null || umlsConcepts.isEmpty()) {
            if (annotation instanceof EventMention) {
                return Collections.singletonList(EVENT_SEMANTIC);
            }
            if (annotation instanceof TimeMention) {
                return Collections.singletonList(TIMEX_SEMANTIC);
            }
            if (annotation instanceof EntityMention) {
                return Collections.singletonList(ENTITY_SEMANTIC);
            }
            return Collections.emptyList();
        }
        HashSet<String> semanticNames = new HashSet<String>();
        for (UmlsConcept umlsConcept : umlsConcepts) {
            semanticNames.add(SemanticGroup.getSemanticName(annotation, umlsConcept));
        }
        ArrayList<String> semanticList = new ArrayList<String>(semanticNames);
        Collections.sort(semanticList);
        return semanticList;
    }

    public static String getSemanticName(IdentifiedAnnotation annotation, UmlsConcept concept) {
        String tui = concept.getTui();
        String semanticName = SemanticGroup.getSemanticName(tui);
        if (semanticName != null && !semanticName.equals(UNKNOWN_SEMANTIC)) {
            return semanticName;
        }
        if (annotation instanceof EventMention) {
            return EVENT_SEMANTIC;
        }
        if (annotation instanceof TimeMention) {
            return TIMEX_SEMANTIC;
        }
        if (annotation instanceof EntityMention) {
            return ENTITY_SEMANTIC;
        }
        return SemanticGroup.getSimpleName(annotation);
    }

    public static String getSemanticName(String tui) {
        if (tui == null || tui.isEmpty()) {
            return UNKNOWN_SEMANTIC;
        }
        for (SemanticGroup semanticGroup : SemanticGroup.values()) {
            if (!semanticGroup._tuis.contains(tui)) continue;
            return semanticGroup._name;
        }
        return UNKNOWN_SEMANTIC;
    }

    public static Collection<String> getSemanticCodes(Collection<IdentifiedAnnotation> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return Collections.emptyList();
        }
        Collection umlsCodes = annotations.stream().map(OntologyConceptUtil::getUmlsConcepts).flatMap(Collection::stream).map(SemanticGroup::getSemanticCode).distinct().sorted().collect(Collectors.toList());
        if (umlsCodes != null && !umlsCodes.isEmpty()) {
            return umlsCodes;
        }
        for (IdentifiedAnnotation annotation : annotations) {
            Class<?> clazz = annotation.getClass();
            if (clazz.equals(EventMention.class)) {
                return Collections.singletonList(EVENT_CODE);
            }
            if (clazz.equals(TimeMention.class)) {
                return Collections.singletonList(TIMEX_CODE);
            }
            if (!clazz.equals(EntityMention.class)) continue;
            return Collections.singletonList(ENTITY_CODE);
        }
        return Collections.emptyList();
    }

    public static String getSemanticCode(UmlsConcept concept) {
        String tui = concept.getTui();
        return SemanticGroup.getSemanticCode(tui);
    }

    public static String getSemanticCode(String tui) {
        if (tui == null || tui.isEmpty()) {
            return UNKNOWN_SEMANTIC_CODE;
        }
        for (SemanticGroup semanticGroup : SemanticGroup.values()) {
            if (!semanticGroup._tuis.contains(tui)) continue;
            return semanticGroup._code;
        }
        return UNKNOWN_SEMANTIC_CODE;
    }

    public static String getNameForCode(String code) {
        for (SemanticGroup semanticGroup : SemanticGroup.values()) {
            if (!semanticGroup._code.equals(code)) continue;
            return semanticGroup._name;
        }
        return UNKNOWN_SEMANTIC;
    }

    private static String getSimpleName(IdentifiedAnnotation annotation) {
        String simpleName = annotation.getClass().getSimpleName();
        if (simpleName.endsWith("Mention")) {
            return simpleName.substring(0, simpleName.length() - 7);
        }
        return simpleName;
    }
}

