/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.ctakes.core.cc.pretty.SemanticGroup;
import org.apache.log4j.Logger;

final class CssWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"CssWriter");

    private CssWriter() {
    }

    static void writeCssFile(String filePath) {
        File outputFile = new File(filePath);
        outputFile.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.write(CssWriter.setLayout());
            writer.write(CssWriter.setUnderline("GNR_", "gray", "solid", "0.12"));
            writer.write(CssWriter.setUnderline("AFF_", "green", "solid", "0.12"));
            writer.write(CssWriter.setUnderline("UNC_", "gold", "dotted", "0.16"));
            writer.write(CssWriter.setUnderline("NEG_", "red", "dashed", "0.14"));
            writer.write(CssWriter.setUnderline("UNN_", "orange", "dashed", "0.14"));
            writer.write(CssWriter.setSuperColor(SemanticGroup.FINDING.getCode(), "magenta"));
            writer.write(CssWriter.setSuperColor(SemanticGroup.DISORDER.getCode(), "black"));
            writer.write(CssWriter.setSuperColor(SemanticGroup.MEDICATION.getCode(), "red"));
            writer.write(CssWriter.setSuperColor(SemanticGroup.PROCEDURE.getCode(), "blue"));
            writer.write(CssWriter.setSuperColor(SemanticGroup.ANATOMICAL_SITE.getCode(), "gray"));
            writer.write(CssWriter.setSuperColor("UNK", "gray"));
            writer.write(CssWriter.getToolTipCss());
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Could not not write css file " + outputFile.getPath()));
            LOGGER.error((Object)ioE.getMessage());
        }
    }

    private static String setLayout() {
        return ".flex-container {\n    display: -webkit-flex;\n    display: flex;  \n    -webkit-flex-flow: row wrap;\n    flex-flow: row wrap;\n    text-align: center;\n}\n\n.flex-container > * {\n    padding: 15px;\n    -webkit-flex: 1 100%;\n    flex: 1 100%;\n}\n\n.article {\n    text-align: left;\n    line-height: 120%;\n    word-spacing: 0.25em;\n}\nheader {\n    background: MidnightBlue;\n    color: white;\n    height: 30px;\n}\nheader h1 {\n    margin-top: 0px;\n}\nfooter {\n    background: SteelBlue;\n    color: white;\n    height: 10px;\n}\n.nav {\n    display: flex;\n    flex-direction: column;\n    flex-shrink: 0;\n    justify-content: space-between;\n    max-width: 320px;\n    background: PowderBlue;\n}\n@media all {\n    .article {\n        -webkit-flex: 5 0px;\n        flex: 5 0px;\n        -webkit-order: 1;\n        order: 1;    }\n    .nav {\n        text-align: left;\n        -webkit-flex: 1 auto;\n        flex: 1 auto;\n        -webkit-order: 2;\n        order: 2;\n    }\n    footer {\n        -webkit-order: 3;\n        order: 3;\n    }\n}\n\n#ia {\n    position: sticky;\n    position: -webkit-sticky;\n    top: 0;\n    background: powderBlue;\n    border-bottom: 2px solid navy;\n    z-index: 10;\n}\n.legend {\n    margin-left: auto;\n    margin-right: auto;\n    max-width: 300px;\n    background: white;\n    border: 2px solid navy;\n    padding: 0 15px 15px 15px;\n    z-index: 1;\n\n}\n.legend h3 {\n    text-align: center;\n}\n.legend table {\n    width: 100%;\n}\n.legend td {\n    width: 50%;\n}\n";
    }

    private static String setUnderline(String className, String color, String dashType, String size) {
        return "\n." + className + " {\n  position: relative;\n  display: inline-block " + color + ";\n  border-bottom: " + size + "em " + dashType + " " + color + ";\n  border-radius: 5px;\n}\n";
    }

    private static String setSuperColor(String className, String color) {
        return "\n." + className + " {\n  color: " + color + ";\n}\n";
    }

    private static String setHighlight(String idName, String color) {
        return "#" + idName + "{\n  background-color: " + color + ";\n}\n";
    }

    private static String getListCss() {
        return "\nul {\n  list-style-type: none;\n  margin: 0;\n  padding: 0;\n}\n\nli {\n  border: 1px solid lightgray;\n  margin: 1px;\n  margin-right: 5px;\n  padding: 2px;\n  padding-left: 5px;\n}\n";
    }

    private static String getToolTipCss() {
        return "\n[TIP] {\n  position: relative;\n  z-index: 2;\n  cursor: pointer;\n}\n[TIP]::before,\n[TIP]::after {\n  visibility: hidden;\n  -ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\n  filter: progid: DXImageTransform.Microsoft.Alpha(Opacity=0);\n  opacity: 0;\n  pointer-events: none;\n}\n[TIP]::before {\n  position: absolute;\n  bottom: 0%;\n  left: 100%;\n  margin-bottom: 5px;\n  padding: 7px;\n  -webkit-border-radius: 3px;\n  -moz-border-radius: 3px;\n  border-radius: 3px;\n  background-color: #000;\n  background-color: hsla(0, 0%, 20%, 0.9);\n  color: #fff;\n  content: attr(TIP);\n  text-align: center;\n  font-size: 14px;\n  line-height: 1.2;\n}\n[TIP]:hover::before,\n[TIP]:hover::after {\n  visibility: visible;\n  -ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\n  filter: progid: DXImageTransform.Microsoft.Alpha(Opacity=100);\n  opacity: 1;\n}\n";
    }
}

