/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ctakes.core.cc.AbstractJCasFileWriter;
import org.apache.ctakes.core.cc.pretty.SemanticGroup;
import org.apache.ctakes.core.cc.pretty.html.CssWriter;
import org.apache.ctakes.core.cc.pretty.html.JsWriter;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.annotation.OntologyConceptUtil;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.core.util.textspan.DefaultTextSpan;
import org.apache.ctakes.core.util.textspan.TextSpan;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.ListEntry;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="HTML Writer", description="Writes html files with document text and simple markups (Semantic Group, CUI, Negation).", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN}, usables={PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX, PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public final class HtmlTextWriter
extends AbstractJCasFileWriter {
    static final String TOOL_TIP = "TIP";
    static final String UNCERTAIN_NEGATED = "UNN_";
    static final String NEGATED = "NEG_";
    static final String UNCERTAIN = "UNC_";
    static final String AFFIRMED = "AFF_";
    static final String GENERIC = "GNR_";
    static final String SPACER = "SPC_";
    static final String NEWLINE = "NL_";
    static final String WIKI_BEGIN = "WIK_";
    static final String WIKI_CENTER = "_WK_";
    static final String WIKI_END = "_WIK";
    private static final Logger LOGGER = Logger.getLogger((String)"HtmlTextWriter");
    private static final String PREFERRED_TERM_UNKNOWN = "Unknown Preferred Term";
    private static final String CTAKES_VERSION = "5.1.0";
    private static final String FILE_EXTENSION = ".pretty.html";
    private static final String CSS_FILENAME = "ctakes.pretty.css";
    private static final String JS_FILENAME = "ctakes.pretty.js";
    private static final Collection<String> _usedDirectories = ConcurrentHashMap.newKeySet();
    private static final Comparator<TextSpan> TEXT_SPAN_COMPARATOR = new TextSpanComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(JCas jCas, String outputDir, String documentId, String fileName) throws IOException {
        Collection<String> collection = _usedDirectories;
        synchronized (collection) {
            if (_usedDirectories.add(outputDir)) {
                String cssPath = outputDir + '/' + CSS_FILENAME;
                CssWriter.writeCssFile(cssPath);
                String jsPath = outputDir + '/' + JS_FILENAME;
                JsWriter.writeJsFile(jsPath);
            }
        }
        File htmlFile = new File(outputDir, fileName + FILE_EXTENSION);
        LOGGER.info((Object)("Writing HTML to " + htmlFile.getPath() + " ..."));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(htmlFile));){
            String title = DocIdUtil.getDocumentID(jCas);
            writer.write(HtmlTextWriter.startBody());
            writer.write(HtmlTextWriter.getCssLink(CSS_FILENAME));
            writer.write(HtmlTextWriter.getJsLink(JS_FILENAME));
            writer.write(HtmlTextWriter.startContainer());
            writer.write(HtmlTextWriter.getHeader(title));
            writer.write(HtmlTextWriter.getNav());
            writer.write(HtmlTextWriter.startArticle());
            Collection sections = JCasUtil.select((JCas)jCas, Segment.class);
            Map lists = JCasUtil.indexCovered((JCas)jCas, Segment.class, org.apache.ctakes.typesystem.type.textspan.List.class);
            Map listEntries = JCasUtil.indexCovered((JCas)jCas, org.apache.ctakes.typesystem.type.textspan.List.class, ListEntry.class);
            Map sectionSentences = JCasUtil.indexCovered((JCas)jCas, Segment.class, Sentence.class);
            Map sentenceAnnotations = JCasUtil.indexCovered((JCas)jCas, Sentence.class, IdentifiedAnnotation.class);
            Map sentenceTokens = JCasUtil.indexCovered((JCas)jCas, Sentence.class, BaseToken.class);
            Collection relations = JCasUtil.select((JCas)jCas, BinaryTextRelation.class);
            Collection paragraphs = JCasUtil.select((JCas)jCas, Paragraph.class);
            HtmlTextWriter.cullAnnotations(sentenceAnnotations.values());
            Collection corefRelations = JCasUtil.select((JCas)jCas, CollectionTextRelation.class);
            Map<Markable, TextSpan> markableSpans = HtmlTextWriter.mapMarkableSpans(jCas, corefRelations);
            Map<TextSpan, Collection<Integer>> corefSpans = HtmlTextWriter.createCorefSpans(corefRelations, markableSpans);
            HtmlTextWriter.writeSections(sections, paragraphs, lists, listEntries, sectionSentences, sentenceAnnotations, sentenceTokens, relations, corefSpans, writer);
            writer.write(HtmlTextWriter.endArticle());
            writer.write(HtmlTextWriter.getFooter());
            writer.write(HtmlTextWriter.endContainer());
            writer.write(HtmlTextWriter.startJavascript());
            if (!corefRelations.isEmpty()) {
                HtmlTextWriter.writeCorefInfos(corefRelations, writer);
            }
            writer.write(HtmlTextWriter.endJavascript());
            writer.write(HtmlTextWriter.endBody());
        }
        LOGGER.info((Object)"Finished Writing");
    }

    private static void cullAnnotations(Collection<Collection<IdentifiedAnnotation>> sentenceAnnotations) {
        Predicate<IdentifiedAnnotation> keep = a -> EventMention.class.isInstance(a) || TimeMention.class.isInstance(a) || EntityMention.class.isInstance(a);
        HashSet keepers = new HashSet();
        for (Collection<IdentifiedAnnotation> annotations : sentenceAnnotations) {
            annotations.stream().filter(keep).forEach(keepers::add);
            annotations.retainAll(keepers);
            keepers.clear();
        }
    }

    private static Map<TextSpan, Collection<Integer>> createCorefSpans(Collection<CollectionTextRelation> corefRelations, Map<Markable, TextSpan> markableSpans) {
        if (corefRelations == null || corefRelations.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<TextSpan, Collection<Integer>> corefSpans = new HashMap<TextSpan, Collection<Integer>>();
        int index = 1;
        for (CollectionTextRelation corefRelation : corefRelations) {
            FSList chainHead = corefRelation.getMembers();
            Collection markables = FSCollectionFactory.create((FSList)chainHead, Markable.class);
            for (Markable markable : markables) {
                TextSpan span = markableSpans.get(markable);
                corefSpans.putIfAbsent(span, new ArrayList());
                ((Collection)corefSpans.get(span)).add(index);
            }
            ++index;
        }
        return corefSpans;
    }

    private static Map<Markable, TextSpan> mapMarkableSpans(JCas jCas, Collection<CollectionTextRelation> corefRelations) {
        if (corefRelations == null || corefRelations.isEmpty()) {
            return Collections.emptyMap();
        }
        Map markableNodes = JCasUtil.indexCovered((JCas)jCas, Markable.class, ConllDependencyNode.class);
        Map nodeAnnotations = JCasUtil.indexCovering((JCas)jCas, ConllDependencyNode.class, IdentifiedAnnotation.class);
        HtmlTextWriter.cullAnnotations(nodeAnnotations.values());
        HashMap<Markable, TextSpan> spanMap = new HashMap<Markable, TextSpan>();
        for (CollectionTextRelation coref : corefRelations) {
            Collection markables = JCasUtil.select((FSList)coref.getMembers(), Markable.class);
            for (Markable markable : markables) {
                Collection nodes = (Collection)markableNodes.get(markable);
                if (nodes == null || nodes.isEmpty()) continue;
                ConllDependencyNode headNode = HtmlTextWriter.getNominalHeadNode(new ArrayList<ConllDependencyNode>(nodes));
                Collection annotations = (Collection)nodeAnnotations.get(headNode);
                if (annotations == null || annotations.isEmpty()) {
                    spanMap.put(markable, new DefaultTextSpan(headNode.getBegin(), headNode.getEnd()));
                    continue;
                }
                DefaultTextSpan bestSpan = null;
                int bestLength = 0;
                for (IdentifiedAnnotation annotation : annotations) {
                    if (!EventMention.class.equals(annotation.getClass()) && annotation.getBegin() == markable.getBegin() && annotation.getEnd() == markable.getEnd()) {
                        bestSpan = new DefaultTextSpan(annotation.getBegin(), annotation.getEnd());
                        break;
                    }
                    if (annotation.getEnd() - annotation.getBegin() <= bestLength) continue;
                    bestLength = annotation.getEnd() - annotation.getBegin();
                    bestSpan = new DefaultTextSpan(annotation.getBegin(), annotation.getEnd());
                }
                if (bestSpan != null) {
                    spanMap.put(markable, bestSpan);
                    continue;
                }
                spanMap.put(markable, new DefaultTextSpan(headNode.getBegin(), headNode.getEnd()));
            }
        }
        return spanMap;
    }

    public static ConllDependencyNode getNominalHeadNode(List<ConllDependencyNode> nodes) {
        int i;
        ArrayList<ConllDependencyNode> anodes = new ArrayList<ConllDependencyNode>(nodes);
        Boolean[][] matrixofheads = new Boolean[anodes.size()][anodes.size()];
        ArrayList<ConllDependencyNode> outnodes = new ArrayList<ConllDependencyNode>();
        for (i = 0; i < anodes.size(); ++i) {
            if (anodes.get(i).getId() != 0) continue;
            anodes.remove(i);
        }
        for (int id1 = 0; id1 < anodes.size(); ++id1) {
            for (int id2 = 0; id2 < anodes.size(); ++id2) {
                matrixofheads[id2][id1] = id1 == id2 || anodes.get(id1).getId() != anodes.get(id2).getHead().getId() ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
        }
        for (int idhd = 0; idhd < anodes.size(); ++idhd) {
            boolean occupiedCol = false;
            for (int row = 0; row < anodes.size(); ++row) {
                if (!matrixofheads[row][idhd].booleanValue()) continue;
                occupiedCol = true;
            }
            if (!occupiedCol) continue;
            boolean occupiedRow = false;
            for (int col = 0; col < anodes.size(); ++col) {
                if (!matrixofheads[idhd][col].booleanValue()) continue;
                occupiedRow = true;
            }
            if (occupiedRow) continue;
            outnodes.add(anodes.get(idhd));
        }
        if (outnodes.isEmpty()) {
            for (i = 0; i < anodes.size(); ++i) {
                if (!Pattern.matches("N..?", anodes.get(i).getPostag())) continue;
                return anodes.get(i);
            }
            return anodes.get(anodes.size() - 1);
        }
        for (i = 0; i < outnodes.size(); ++i) {
            if (!Pattern.matches("N..?", ((ConllDependencyNode)outnodes.get(i)).getPostag())) continue;
            return (ConllDependencyNode)outnodes.get(i);
        }
        return (ConllDependencyNode)outnodes.get(outnodes.size() - 1);
    }

    private static IdentifiedAnnotation getEvent(Collection<IdentifiedAnnotation> annotations) {
        return annotations.stream().filter(a -> EventMention.class.equals(a.getClass())).findAny().orElse(null);
    }

    private static Map<IdentifiedAnnotation, IdentifiedAnnotation> getAnnotationEvents(Map<TextSpan, Collection<IdentifiedAnnotation>> annotationMap) {
        HashMap<IdentifiedAnnotation, IdentifiedAnnotation> annotationEvents = new HashMap<IdentifiedAnnotation, IdentifiedAnnotation>();
        HashMap unusedEvents = new HashMap();
        for (Map.Entry<TextSpan, Collection<IdentifiedAnnotation>> entry : annotationMap.entrySet()) {
            Collection<IdentifiedAnnotation> collection = entry.getValue();
            IdentifiedAnnotation event = HtmlTextWriter.getEvent(collection);
            if (event == null) continue;
            if (collection.size() > 1) {
                int pre = annotationEvents.size();
                collection.stream().filter(EventMention.class::isInstance).filter(a -> !event.equals(a)).forEach(a -> annotationEvents.put((IdentifiedAnnotation)a, event));
                if (annotationEvents.size() > pre) {
                    collection.remove(event);
                    continue;
                }
                unusedEvents.put(entry.getKey(), event);
                continue;
            }
            unusedEvents.put(entry.getKey(), event);
        }
        if (unusedEvents.isEmpty()) {
            return annotationEvents;
        }
        HashMap usedEvents = new HashMap();
        for (Map.Entry entry : annotationMap.entrySet()) {
            TextSpan span = (TextSpan)entry.getKey();
            TextSpan usedEventSpan = null;
            for (Map.Entry unusedEvent : unusedEvents.entrySet()) {
                if (span.equals(unusedEvent.getKey()) || !span.contains((TextSpan)unusedEvent.getKey())) continue;
                ((Collection)entry.getValue()).stream().filter(EventMention.class::isInstance).forEach(a -> {
                    IdentifiedAnnotation cfr_ignored_0 = (IdentifiedAnnotation)annotationEvents.put((IdentifiedAnnotation)a, (IdentifiedAnnotation)unusedEvent.getValue());
                });
                usedEventSpan = (TextSpan)unusedEvent.getKey();
                usedEvents.put(usedEventSpan, unusedEvent.getValue());
                break;
            }
            if (usedEventSpan == null) continue;
            unusedEvents.remove(usedEventSpan);
            if (!unusedEvents.isEmpty()) continue;
            break;
        }
        usedEvents.forEach((s, e) -> ((Collection)annotationMap.get(s)).remove(e));
        Collection emptySpans = annotationMap.entrySet().stream().filter(e -> ((Collection)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
        annotationMap.keySet().removeAll(emptySpans);
        return annotationEvents;
    }

    private static String startBody() {
        return "<!DOCTYPE html>\n<html>\n<body>\n";
    }

    private static String getCssLink(String filePath) {
        return "<link rel=\"stylesheet\" href=\"" + filePath + "\" type=\"text/css\" media=\"screen\">";
    }

    private static String getJsLink(String filePath) {
        return "<script type=\"text/javascript\" src=\"ctakes.pretty.js\"></script>\n";
    }

    private static String startJavascript() {
        return "<script type=\"text/javascript\">";
    }

    private static String endJavascript() {
        return "</script>";
    }

    private static String startContainer() {
        return "<div class=\"flex-container\">\n";
    }

    private static String getHeader(String title) {
        return "<header>\n  <h1>" + title + "</h1>\n</header>\n";
    }

    private static String getNav() {
        return "<nav class=\"nav\">\n    <div id=\"ia\">\n      Annotation Information\n    </div>\n" + HtmlTextWriter.getLegend() + "</nav>\n";
    }

    private static String startArticle() {
        return "<article class=\"article\">\n";
    }

    private static String endArticle() {
        return "</article>\n";
    }

    private static String getFooter() {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("L dd yyyy, HH:mm:ss");
        return "<footer>\nProcessed by Apache cTAKES<sup>&copy;</sup> on " + formatter.format(time) + "\n</footer>\n";
    }

    private static String endContainer() {
        return "</div>\n";
    }

    private static void writeSections(Map<Segment, Collection<Sentence>> sectionSentences, Collection<Paragraph> paragraphs, Map<Sentence, Collection<IdentifiedAnnotation>> sentenceAnnotations, Map<Sentence, Collection<BaseToken>> sentenceTokens, Collection<BinaryTextRelation> relations, Map<TextSpan, Collection<Integer>> corefSpans, BufferedWriter writer) throws IOException {
        Collection paragraphBegins = paragraphs.stream().map(Annotation::getBegin).collect(Collectors.toList());
        ArrayList<Segment> sections = new ArrayList<Segment>(sectionSentences.keySet());
        sections.sort(Comparator.comparingInt(Annotation::getBegin));
        for (Segment section : sections) {
            HtmlTextWriter.writeSectionHeader(section, writer);
            writer.write("\n<p>\n");
            ArrayList<Sentence> sentences = new ArrayList<Sentence>(sectionSentences.get(section));
            sentences.sort(Comparator.comparingInt(Annotation::getBegin));
            for (Sentence sentence : sentences) {
                Collection<IdentifiedAnnotation> annotations = sentenceAnnotations.get(sentence);
                Collection<BaseToken> tokens = sentenceTokens.get(sentence);
                HtmlTextWriter.writeSentence(sentence, annotations, tokens, relations, corefSpans, writer);
                if (!paragraphBegins.contains(sentence.getEnd())) continue;
                writer.write("\n</p>\n<p>\n");
            }
            writer.write("\n</p>\n");
        }
    }

    private static void writeSections(Collection<Segment> sectionSet, Collection<Paragraph> paragraphs, Map<Segment, Collection<org.apache.ctakes.typesystem.type.textspan.List>> lists, Map<org.apache.ctakes.typesystem.type.textspan.List, Collection<ListEntry>> listEntries, Map<Segment, Collection<Sentence>> sectionSentences, Map<Sentence, Collection<IdentifiedAnnotation>> sentenceAnnotations, Map<Sentence, Collection<BaseToken>> sentenceTokens, Collection<BinaryTextRelation> relations, Map<TextSpan, Collection<Integer>> corefSpans, BufferedWriter writer) throws IOException {
        if (lists.isEmpty()) {
            HtmlTextWriter.writeSections(sectionSentences, paragraphs, sentenceAnnotations, sentenceTokens, relations, corefSpans, writer);
            return;
        }
        Collection paragraphBegins = paragraphs.stream().map(Annotation::getBegin).collect(Collectors.toList());
        ArrayList<Segment> sections = new ArrayList<Segment>(sectionSet);
        sections.sort(Comparator.comparingInt(Annotation::getBegin));
        HashMap enclosers = new HashMap();
        for (Map.Entry<org.apache.ctakes.typesystem.type.textspan.List, Collection<ListEntry>> entry : listEntries.entrySet()) {
            int listEnd = entry.getKey().getEnd();
            entry.getValue().forEach(e -> enclosers.put(e.getBegin(), listEnd));
        }
        for (Segment section : sections) {
            HtmlTextWriter.writeSectionHeader(section, writer);
            Collection<Sentence> sentenceSet = sectionSentences.get(section);
            if (sentenceSet == null) continue;
            writer.write("\n<p>\n");
            ArrayList<Sentence> sentences = new ArrayList<Sentence>(sentenceSet);
            sentences.sort(Comparator.comparingInt(Annotation::getBegin));
            int currentEnd = -1;
            boolean freshEntry = false;
            for (Sentence sentence : sentences) {
                Collection<IdentifiedAnnotation> annotations = sentenceAnnotations.get(sentence);
                Collection<BaseToken> tokens = sentenceTokens.get(sentence);
                Integer end = (Integer)enclosers.get(sentence.getBegin());
                if (end != null) {
                    freshEntry = true;
                    if (currentEnd < 0) {
                        HtmlTextWriter.startList(sentence, annotations, tokens, relations, corefSpans, writer);
                        currentEnd = end;
                        continue;
                    }
                    HtmlTextWriter.writeListEntry(sentence, annotations, tokens, relations, corefSpans, writer);
                    continue;
                }
                if (currentEnd >= 0 && sentence.getBegin() > currentEnd) {
                    HtmlTextWriter.endList(sentence, annotations, tokens, relations, corefSpans, writer);
                    currentEnd = -1;
                    freshEntry = false;
                    continue;
                }
                if (freshEntry) {
                    freshEntry = false;
                    writer.write("\n<br>\n");
                }
                HtmlTextWriter.writeSentence(sentence, annotations, tokens, relations, corefSpans, writer);
                if (!paragraphBegins.contains(sentence.getEnd())) continue;
                writer.write("\n</p>\n<p>\n");
            }
            if (currentEnd >= 0) {
                HtmlTextWriter.endList(writer);
            }
            writer.write("\n</p>\n");
        }
    }

    private static String createLineText(Sentence sentence, Collection<IdentifiedAnnotation> annotations, Map<TextSpan, String> baseTokenMap, Collection<BinaryTextRelation> relations, Map<TextSpan, Collection<Integer>> corefSpans) {
        Map<TextSpan, Collection<IdentifiedAnnotation>> annotationMap = HtmlTextWriter.createAnnotationMap(sentence, annotations);
        Map<IdentifiedAnnotation, IdentifiedAnnotation> annotationEvents = HtmlTextWriter.getAnnotationEvents(annotationMap);
        Map<Integer, String> tags = HtmlTextWriter.createTags(sentence, annotationMap, annotationEvents, relations, corefSpans);
        StringBuilder sb = new StringBuilder();
        int previousIndex = -1;
        for (Map.Entry<TextSpan, String> entry : baseTokenMap.entrySet()) {
            String beginTag;
            String text = entry.getValue();
            int begin = entry.getKey().getBegin();
            if (begin != previousIndex && (beginTag = tags.get(begin)) != null) {
                sb.append(beginTag);
            }
            sb.append(text);
            int end = entry.getKey().getEnd();
            String endTag = tags.get(end);
            if (endTag != null) {
                sb.append(endTag);
            }
            sb.append(" ");
            previousIndex = end;
        }
        return sb.toString();
    }

    private static void startList(Sentence sentence, Collection<IdentifiedAnnotation> annotations, Collection<BaseToken> baseTokens, Collection<BinaryTextRelation> relations, Map<TextSpan, Collection<Integer>> corefSpans, BufferedWriter writer) throws IOException {
        if (baseTokens.isEmpty()) {
            return;
        }
        Map<TextSpan, String> baseTokenMap = HtmlTextWriter.createBaseTokenMap(sentence, baseTokens);
        if (baseTokenMap.isEmpty()) {
            return;
        }
        writer.write("\n<ul>\n<li>");
        String lineText = HtmlTextWriter.createLineText(sentence, annotations, baseTokenMap, relations, corefSpans);
        writer.write(lineText);
    }

    private static void writeListEntry(Sentence sentence, Collection<IdentifiedAnnotation> annotations, Collection<BaseToken> baseTokens, Collection<BinaryTextRelation> relations, Map<TextSpan, Collection<Integer>> corefSpans, BufferedWriter writer) throws IOException {
        if (baseTokens.isEmpty()) {
            return;
        }
        Map<TextSpan, String> baseTokenMap = HtmlTextWriter.createBaseTokenMap(sentence, baseTokens);
        if (baseTokenMap.isEmpty()) {
            return;
        }
        writer.write("</li>\n<li>");
        String lineText = HtmlTextWriter.createLineText(sentence, annotations, baseTokenMap, relations, corefSpans);
        writer.write(lineText);
    }

    private static void endList(Sentence sentence, Collection<IdentifiedAnnotation> annotations, Collection<BaseToken> baseTokens, Collection<BinaryTextRelation> relations, Map<TextSpan, Collection<Integer>> corefSpans, BufferedWriter writer) throws IOException {
        if (baseTokens.isEmpty()) {
            return;
        }
        Map<TextSpan, String> baseTokenMap = HtmlTextWriter.createBaseTokenMap(sentence, baseTokens);
        if (baseTokenMap.isEmpty()) {
            return;
        }
        String lineText = HtmlTextWriter.createLineText(sentence, annotations, baseTokenMap, relations, corefSpans);
        writer.write(lineText + "</li>\n</ul>\n");
    }

    private static void endList(BufferedWriter writer) throws IOException {
        writer.write("</li>\n</ul>\n");
    }

    private static void writeSectionHeader(Segment section, BufferedWriter writer) throws IOException {
        String sectionId = section.getId();
        if (sectionId.equals("SIMPLE_SEGMENT")) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n<h3");
        String sectionTag = HtmlTextWriter.getSafeText(section.getTagText());
        if (sectionTag != null && !sectionTag.trim().isEmpty()) {
            sb.append(" onClick=\"iaf('").append(sectionTag.trim()).append("')\"");
        }
        sb.append(">").append(HtmlTextWriter.getSafeText(sectionId));
        String sectionName = section.getPreferredText();
        if (sectionName != null && !sectionName.trim().isEmpty() && !sectionName.trim().equals(sectionId)) {
            sb.append(" : ").append(HtmlTextWriter.getSafeText(sectionName));
        }
        sb.append("</h3>\n");
        writer.write(sb.toString());
    }

    private static void writeSentence(Sentence sentence, Collection<IdentifiedAnnotation> annotations, Collection<BaseToken> baseTokens, Collection<BinaryTextRelation> relations, Map<TextSpan, Collection<Integer>> corefSpans, BufferedWriter writer) throws IOException {
        if (baseTokens.isEmpty()) {
            return;
        }
        Map<TextSpan, String> baseTokenMap = HtmlTextWriter.createBaseTokenMap(sentence, baseTokens);
        if (baseTokenMap.isEmpty()) {
            return;
        }
        String lineText = HtmlTextWriter.createLineText(sentence, annotations, baseTokenMap, relations, corefSpans);
        writer.write(lineText + "\n<br>\n");
    }

    private static Map<TextSpan, String> createBaseTokenMap(Sentence sentence, Collection<BaseToken> baseTokens) {
        int sentenceBegin = sentence.getBegin();
        LinkedHashMap<TextSpan, String> baseItemMap = new LinkedHashMap<TextSpan, String>();
        for (BaseToken baseToken : baseTokens) {
            String text;
            DefaultTextSpan textSpan = new DefaultTextSpan((AnnotationFS)baseToken, sentenceBegin);
            if (textSpan.getWidth() == 0 || (text = HtmlTextWriter.getSafeText((Annotation)baseToken)).isEmpty()) continue;
            baseItemMap.put(textSpan, text);
        }
        return baseItemMap;
    }

    private static String getSafeText(Annotation annotation) {
        if (annotation == null) {
            return "";
        }
        return HtmlTextWriter.getSafeText(annotation.getCoveredText().trim());
    }

    private static String getSafeText(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String safeText = text.replace("'", "&apos;");
        safeText = safeText.replace("\"", "&quot;");
        safeText = safeText.replace("@", "&amp;");
        safeText = safeText.replace("<", "&lt;");
        safeText = safeText.replace(">", "&gt;");
        return safeText;
    }

    private static Map<TextSpan, Collection<IdentifiedAnnotation>> createAnnotationMap(Sentence sentence, Collection<IdentifiedAnnotation> annotations) {
        HashMap<TextSpan, Collection<IdentifiedAnnotation>> annotationMap = new HashMap<TextSpan, Collection<IdentifiedAnnotation>>();
        int sentenceBegin = sentence.getBegin();
        for (IdentifiedAnnotation annotation : annotations) {
            Collection<String> semanticNames;
            DefaultTextSpan textSpan = new DefaultTextSpan((AnnotationFS)annotation, sentenceBegin);
            if (textSpan.getWidth() == 0 || (semanticNames = SemanticGroup.getSemanticNames(annotation)).isEmpty()) continue;
            annotationMap.putIfAbsent(textSpan, new ArrayList());
            ((Collection)annotationMap.get(textSpan)).add(annotation);
        }
        return annotationMap;
    }

    private static Map<Integer, Character> createIndexMap(Collection<TextSpan> textSpans) {
        if (textSpans.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<TextSpan> spanList = new ArrayList<TextSpan>(textSpans);
        spanList.sort(TEXT_SPAN_COMPARATOR);
        int spanCount = spanList.size();
        int spanCountMinus = spanCount - 1;
        HashMap<Integer, Character> indexMap = new HashMap<Integer, Character>();
        for (int i = 0; i < spanCountMinus; ++i) {
            TextSpan nextSpan;
            TextSpan textSpan = (TextSpan)spanList.get(i);
            int begin = textSpan.getBegin();
            indexMap.putIfAbsent(begin, Character.valueOf('B'));
            int end = textSpan.getEnd();
            indexMap.putIfAbsent(end, Character.valueOf('E'));
            for (int j = i + 1; j < spanCount && (nextSpan = (TextSpan)spanList.get(j)).getBegin() <= end; ++j) {
                if (nextSpan.getBegin() > begin) {
                    indexMap.put(nextSpan.getBegin(), Character.valueOf('I'));
                }
                if (nextSpan.getEnd() < end) {
                    indexMap.put(nextSpan.getEnd(), Character.valueOf('I'));
                    continue;
                }
                if (nextSpan.getEnd() <= end) continue;
                indexMap.put(end, Character.valueOf('I'));
            }
        }
        TextSpan lastSpan = (TextSpan)spanList.get(spanCountMinus);
        indexMap.putIfAbsent(lastSpan.getBegin(), Character.valueOf('B'));
        indexMap.putIfAbsent(lastSpan.getEnd(), Character.valueOf('E'));
        return indexMap;
    }

    private static Collection<TextSpan> createAdjustedSpans(Map<Integer, Character> indexMap) {
        if (indexMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>(indexMap.keySet());
        Collections.sort(indexList);
        int indexCount = indexList.size();
        ArrayList<TextSpan> newSpans = new ArrayList<TextSpan>();
        Integer index1 = (Integer)indexList.get(0);
        Character c1 = indexMap.get(index1);
        for (int i = 1; i < indexCount; ++i) {
            Integer index2 = (Integer)indexList.get(i);
            Character c2 = indexMap.get(index2);
            if (c1.equals(Character.valueOf('B')) || c1.equals(Character.valueOf('I'))) {
                newSpans.add(new DefaultTextSpan(index1, (int)index2));
            }
            index1 = index2;
            c1 = c2;
        }
        return newSpans;
    }

    private static Map<TextSpan, Collection<IdentifiedAnnotation>> createAdjustedAnnotations(List<TextSpan> adjustedList, Map<TextSpan, Collection<IdentifiedAnnotation>> annotationMap) {
        ArrayList<TextSpan> spanList = new ArrayList<TextSpan>(annotationMap.keySet());
        spanList.sort(TEXT_SPAN_COMPARATOR);
        HashMap<TextSpan, Collection<IdentifiedAnnotation>> spanAnnotations = new HashMap<TextSpan, Collection<IdentifiedAnnotation>>(adjustedList.size());
        int spanCount = spanList.size();
        int previousMatchIndex = 0;
        for (TextSpan adjusted : adjustedList) {
            boolean matched = false;
            for (int i = previousMatchIndex; i < spanCount; ++i) {
                TextSpan annotationsSpan = (TextSpan)spanList.get(i);
                if (!annotationsSpan.overlaps(adjusted)) continue;
                if (!matched) {
                    previousMatchIndex = i;
                    matched = true;
                }
                spanAnnotations.putIfAbsent(adjusted, new HashSet());
                ((Collection)spanAnnotations.get(adjusted)).addAll(annotationMap.get(annotationsSpan));
            }
        }
        return spanAnnotations;
    }

    private static Map<TextSpan, Collection<Integer>> getSentenceCorefs(Sentence sentence, Map<TextSpan, Collection<Integer>> corefSpans) {
        HashMap<TextSpan, Collection<Integer>> sentenceCorefs = new HashMap<TextSpan, Collection<Integer>>();
        int sentenceBegin = sentence.getBegin();
        int sentenceEnd = sentence.getEnd();
        for (Map.Entry<TextSpan, Collection<Integer>> entry : corefSpans.entrySet()) {
            int entryBegin = entry.getKey().getBegin();
            if (entryBegin < sentenceBegin || entryBegin >= sentenceEnd) continue;
            sentenceCorefs.put(new DefaultTextSpan(entryBegin - sentenceBegin, entry.getKey().getEnd() - sentenceBegin), entry.getValue());
        }
        return sentenceCorefs;
    }

    private static Map<Integer, String> createTags(Sentence sentence, Map<TextSpan, Collection<IdentifiedAnnotation>> annotationMap, Map<IdentifiedAnnotation, IdentifiedAnnotation> annotationEvents, Collection<BinaryTextRelation> relations, Map<TextSpan, Collection<Integer>> corefSpans) {
        if (annotationMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<TextSpan> spans = new HashSet<TextSpan>(annotationMap.keySet());
        Map<TextSpan, Collection<Integer>> sentenceCorefs = HtmlTextWriter.getSentenceCorefs(sentence, corefSpans);
        spans.addAll(sentenceCorefs.keySet());
        Map<Integer, Character> indexMap = HtmlTextWriter.createIndexMap(spans);
        Collection<TextSpan> adjustedSpans = HtmlTextWriter.createAdjustedSpans(indexMap);
        ArrayList<TextSpan> adjustedList = new ArrayList<TextSpan>(adjustedSpans);
        adjustedList.sort(TEXT_SPAN_COMPARATOR);
        Map<TextSpan, Collection<IdentifiedAnnotation>> adjustedAnnotations = HtmlTextWriter.createAdjustedAnnotations(adjustedList, annotationMap);
        int sentenceBegin = sentence.getBegin();
        HashMap<Integer, String> indexTags = new HashMap<Integer, String>();
        for (TextSpan adjustedSpan : adjustedList) {
            Collection<Integer> chains;
            String tip;
            String clickInfo;
            StringBuilder sb = new StringBuilder("<span");
            Collection<IdentifiedAnnotation> annotations = adjustedAnnotations.get(adjustedSpan);
            String polarityClasses = HtmlTextWriter.createPolaritiesText(annotations);
            if (!polarityClasses.isEmpty()) {
                sb.append(" class=\"").append(polarityClasses).append('\"');
            }
            if (!(clickInfo = HtmlTextWriter.createClickInfo(annotations, annotationEvents, relations)).isEmpty()) {
                sb.append(" onClick=\"iaf('").append(clickInfo).append("')\"");
            }
            if (!(tip = HtmlTextWriter.createTipText(annotations)).isEmpty()) {
                sb.append(" TIP=\"").append(tip).append('\"');
            }
            sb.append('>');
            int adjustedEnd = sentenceBegin + adjustedSpan.getEnd();
            StringBuilder sb2 = new StringBuilder();
            Collection<IdentifiedAnnotation> endAnnotations = HtmlTextWriter.getEndAnnotations(annotations, adjustedEnd);
            Collection<String> semanticCodes = SemanticGroup.getSemanticCodes(endAnnotations);
            String semantic = semanticCodes.stream().findAny().orElse("ENT");
            if (annotations != null && endAnnotations.size() != annotations.size()) {
                semantic = semantic + " " + polarityClasses;
            }
            if ((chains = sentenceCorefs.get(adjustedSpan)) != null && !chains.isEmpty()) {
                for (Integer chain : chains) {
                    sb2.append("<span class=\"").append(semantic).append("\"");
                    sb2.append(" onClick=\"crf").append(chain).append("()\">");
                    sb2.append("<sup>").append(chain).append("</sup></span>");
                }
            } else {
                for (String semanticCode : semanticCodes) {
                    if (semanticCode.equals("EVT") || semanticCode.equals("TMX") || semanticCode.equals("ENT") || semanticCode.equals("UNK")) continue;
                    sb2.append("<span class=\"").append(semanticCode);
                    if (endAnnotations.size() != annotations.size()) {
                        sb2.append(" ").append(polarityClasses);
                    }
                    sb2.append("\"><sup>&#").append(HtmlTextWriter.getSemanticSymbol(semanticCode)).append(";</sup></span>");
                }
            }
            Integer begin = adjustedSpan.getBegin();
            String previousTag = indexTags.getOrDefault(begin, "");
            indexTags.put(begin, previousTag + sb.toString());
            indexTags.put(adjustedSpan.getEnd(), "</span>" + sb2.toString());
        }
        return indexTags;
    }

    private static Collection<IdentifiedAnnotation> getEndAnnotations(Collection<IdentifiedAnnotation> annotations, int adjustedEnd) {
        if (annotations == null || annotations.isEmpty()) {
            return Collections.emptyList();
        }
        return annotations.stream().filter(a -> a.getEnd() == adjustedEnd).collect(Collectors.toSet());
    }

    private static String createClickInfo(Collection<IdentifiedAnnotation> annotations, Map<IdentifiedAnnotation, IdentifiedAnnotation> annotationEvents, Collection<BinaryTextRelation> relations) {
        Map infoMap;
        if (annotations == null || annotations.isEmpty()) {
            return "";
        }
        HashMap polarInfoMap = new HashMap();
        for (IdentifiedAnnotation annotation : annotations) {
            String polarity = HtmlTextWriter.createPolarity(annotation);
            polarInfoMap.putIfAbsent(polarity, new HashMap());
            IdentifiedAnnotation event = annotationEvents.get(annotation);
            infoMap = HtmlTextWriter.createInfoMap(annotation, event, relations);
            for (Map.Entry<String, Collection<String>> infoEntry : infoMap.entrySet()) {
                ((Map)polarInfoMap.get(polarity)).putIfAbsent(infoEntry.getKey(), new HashSet());
                ((Collection)((Map)polarInfoMap.get(polarity)).get(infoEntry.getKey())).addAll(infoEntry.getValue());
            }
        }
        ArrayList polarities = new ArrayList(polarInfoMap.keySet());
        Collections.sort(polarities);
        StringBuilder sb = new StringBuilder();
        for (String polarity : polarities) {
            sb.append(polarity).append(NEWLINE);
            infoMap = (Map)polarInfoMap.get(polarity);
            ArrayList semantics = new ArrayList(infoMap.keySet());
            Collections.sort(semantics);
            for (String semantic : semantics) {
                sb.append(semantic).append(NEWLINE);
                ArrayList texts = new ArrayList((Collection)infoMap.get(semantic));
                Collections.sort(texts);
                for (String text : texts) {
                    sb.append(text).append(NEWLINE);
                }
            }
        }
        return sb.toString();
    }

    private static Map<String, Collection<String>> createInfoMap(IdentifiedAnnotation annotation, IdentifiedAnnotation event, Collection<BinaryTextRelation> relations) {
        Collection<UmlsConcept> concepts = OntologyConceptUtil.getUmlsConcepts(annotation);
        HashMap<String, Collection<String>> semanticMap = new HashMap<String, Collection<String>>();
        String coveredText = HtmlTextWriter.getCoveredText(annotation);
        String safeText = HtmlTextWriter.getSafeText(coveredText);
        String relationText = HtmlTextWriter.getRelationText(annotation, relations);
        if (event != null) {
            relationText = relationText + HtmlTextWriter.getRelationText(event, relations);
        }
        for (UmlsConcept concept : concepts) {
            String semanticCode = SemanticGroup.getSemanticCode(concept);
            semanticMap.putIfAbsent(semanticCode, new HashSet());
            String prefText = HtmlTextWriter.getPreferredText(coveredText, concept);
            String text = HtmlTextWriter.getWikiText(safeText, prefText) + NEWLINE + HtmlTextWriter.getCodes(concept) + HtmlTextWriter.getCodedPrefText(prefText) + relationText;
            if (annotation instanceof EventMention) {
                text = text + HtmlTextWriter.getDocTimeRel((EventMention)annotation);
            }
            ((Collection)semanticMap.get(semanticCode)).add(text);
        }
        if (concepts.isEmpty()) {
            String semanticCode = "";
            String postText = "";
            if (annotation instanceof EventMention) {
                semanticCode = "EVT";
                postText = HtmlTextWriter.getDocTimeRel((EventMention)annotation);
            } else if (annotation instanceof TimeMention) {
                semanticCode = "TMX";
            } else if (annotation instanceof EntityMention) {
                semanticCode = "ENT";
            }
            if (!semanticCode.isEmpty()) {
                semanticMap.putIfAbsent(semanticCode, new HashSet());
                ((Collection)semanticMap.get(semanticCode)).add(safeText + NEWLINE + postText + relationText);
            }
        }
        return semanticMap;
    }

    private static String createWikiLink(String coveredText, String wikiText) {
        return WIKI_BEGIN + wikiText + WIKI_CENTER + coveredText + WIKI_END;
    }

    private static String getCodes(UmlsConcept concept) {
        String code;
        String codes = "";
        String cui = concept.getCui();
        if (cui != null && !cui.isEmpty()) {
            codes = codes + SPACER + cui + NEWLINE;
        }
        if ((code = concept.getCode()) != null && !code.isEmpty()) {
            codes = codes + SPACER + code + NEWLINE;
        }
        return codes;
    }

    private static String getCoveredText(IdentifiedAnnotation annotation) {
        return annotation.getCoveredText().replace('\r', ' ').replace('\n', ' ');
    }

    private static String getPreferredText(String coveredText, UmlsConcept concept) {
        String preferredText = concept.getPreferredText();
        if (!(preferredText == null || preferredText.isEmpty() || preferredText.equals(PREFERRED_TERM_UNKNOWN) || preferredText.equalsIgnoreCase(coveredText) || preferredText.equalsIgnoreCase(coveredText + 's') || coveredText.equalsIgnoreCase(preferredText + 's'))) {
            return HtmlTextWriter.getSafeText(preferredText);
        }
        return "";
    }

    private static String getCodedPrefText(String preferredText) {
        if (!preferredText.isEmpty()) {
            return "SPC_[" + preferredText + "]" + NEWLINE;
        }
        return "";
    }

    private static String getWikiText(String coveredText, String preferredText) {
        String wikiText = coveredText;
        return WIKI_BEGIN + wikiText.replace(' ', '+').toLowerCase() + WIKI_CENTER + coveredText + WIKI_END;
    }

    private static String getDocTimeRel(EventMention eventMention) {
        Event event = eventMention.getEvent();
        if (event == null) {
            return "";
        }
        EventProperties eventProperties = event.getProperties();
        if (eventProperties == null) {
            return "";
        }
        String dtr = eventProperties.getDocTimeRel();
        if (dtr == null || dtr.isEmpty()) {
            return "";
        }
        return "SPC_[" + dtr.toLowerCase() + "] doc time" + NEWLINE;
    }

    private static String createPolaritiesText(Collection<IdentifiedAnnotation> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return GENERIC;
        }
        return annotations.stream().map(HtmlTextWriter::createPolarity).distinct().sorted().collect(Collectors.joining(" "));
    }

    private static String createPolarity(IdentifiedAnnotation annotation) {
        if (annotation instanceof TimeMention || annotation instanceof EntityMention) {
            return GENERIC;
        }
        if (annotation.getPolarity() < 0) {
            if (annotation.getUncertainty() > 0) {
                return UNCERTAIN_NEGATED;
            }
            return NEGATED;
        }
        if (annotation.getUncertainty() > 0) {
            return UNCERTAIN;
        }
        return AFFIRMED;
    }

    private static String createTipText(Collection<IdentifiedAnnotation> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return "";
        }
        Map<String, Integer> semanticCounts = HtmlTextWriter.getSemanticCounts(annotations);
        ArrayList<String> semantics = new ArrayList<String>(semanticCounts.keySet());
        Collections.sort(semantics);
        StringBuilder sb = new StringBuilder();
        for (String semanticName : semantics) {
            sb.append(semanticName);
            int count = semanticCounts.get(semanticName);
            if (count > 1) {
                sb.append('(').append(count).append(')');
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String getRelationText(IdentifiedAnnotation annotation, Collection<BinaryTextRelation> relations) {
        return relations.stream().map(r -> HtmlTextWriter.getRelationText(annotation, r)).collect(Collectors.joining());
    }

    private static String getRelationText(IdentifiedAnnotation annotation, BinaryTextRelation relation) {
        if (relation.getArg1().getArgument().equals((Object)annotation)) {
            return "SPC_[" + relation.getCategory() + "] " + HtmlTextWriter.getSafeText(relation.getArg2().getArgument()) + NEWLINE;
        }
        if (relation.getArg2().getArgument().equals((Object)annotation)) {
            return SPACER + HtmlTextWriter.getSafeText(relation.getArg1().getArgument()) + " [" + relation.getCategory() + "]" + NEWLINE;
        }
        return "";
    }

    private static Map<String, Integer> getSemanticCounts(Collection<IdentifiedAnnotation> annotations) {
        HashSet<String> usedCuis = new HashSet<String>();
        HashMap<String, Integer> semanticCounts = new HashMap<String, Integer>();
        for (IdentifiedAnnotation annotation : annotations) {
            Collection<UmlsConcept> concepts = OntologyConceptUtil.getUmlsConcepts(annotation);
            for (UmlsConcept concept : concepts) {
                if (!usedCuis.add(concept.getCui())) continue;
                String semanticName = SemanticGroup.getSemanticName(annotation, concept);
                semanticCounts.putIfAbsent(semanticName, 0);
                int count = (Integer)semanticCounts.get(semanticName);
                semanticCounts.put(semanticName, count + 1);
            }
            usedCuis.clear();
            if (!concepts.isEmpty()) continue;
            String semanticName = "";
            if (annotation instanceof EventMention) {
                semanticName = "Event";
            } else if (annotation instanceof TimeMention) {
                semanticName = "Time";
            }
            if (semanticName.isEmpty()) continue;
            semanticCounts.putIfAbsent(semanticName, 0);
            int count = (Integer)semanticCounts.get(semanticName);
            semanticCounts.put(semanticName, count + 1);
        }
        return semanticCounts;
    }

    private static int getSemanticSymbol(String semanticCode) {
        if (semanticCode.equals(SemanticGroup.ANATOMICAL_SITE.getCode())) {
            return 9673;
        }
        if (semanticCode.equals(SemanticGroup.FINDING.getCode())) {
            return 8226;
        }
        if (semanticCode.equals(SemanticGroup.PROCEDURE.getCode())) {
            return 9670;
        }
        if (semanticCode.equals(SemanticGroup.DISORDER.getCode())) {
            return 9661;
        }
        if (semanticCode.equals(SemanticGroup.MEDICATION.getCode())) {
            return 9651;
        }
        return 9726;
    }

    private static void writeCorefInfos(Collection<CollectionTextRelation> corefRelations, BufferedWriter writer) throws IOException {
        if (corefRelations == null || corefRelations.isEmpty()) {
            return;
        }
        int index = 1;
        for (CollectionTextRelation corefRelation : corefRelations) {
            FSList chainHead = corefRelation.getMembers();
            Collection markables = FSCollectionFactory.create((FSList)chainHead, IdentifiedAnnotation.class);
            String text = markables.stream().sorted(Comparator.comparingInt(Annotation::getBegin)).map(HtmlTextWriter::getSafeText).collect(Collectors.joining("<br>"));
            writer.write("  function crf" + index + "() {\n");
            writer.write("    document.getElementById(\"ia\").innerHTML = \"<br><h3>Coreference Chain</h3>" + text + "\";\n");
            writer.write("  }\n");
            ++index;
        }
    }

    private static String getLegend() {
        return "<div class=\"legend\"><h3>Legend</h3>\n  <hr>\n  <table style=\"line-height: 120%\">\n    <tr>\n      <td><span class=\"AFF_\">Affirmed Event</span></td>\n      <td><span class=\"NEG_\">Negated Event</span></td>\n    </tr>\n    <tr>\n      <td><span class=\"UNC_\">Uncertain Event</span></td>\n      <td><span class=\"UNN_\">Uncertain Negated</span></td>\n    </tr>\n    <tr>\n      <td><span class=\"GNR_\">Time or Generic</span></td>\n    </tr>\n  </table>\n  <hr>\n  <table>\n    <tr>\n      <td>Sign / Symptom<span class=\"FND\"><sup>&#" + HtmlTextWriter.getSemanticSymbol(SemanticGroup.FINDING.getCode()) + ";</sup></span></td>\n      <td>Procedure<span class=\"PRC\"><sup>&#" + HtmlTextWriter.getSemanticSymbol(SemanticGroup.PROCEDURE.getCode()) + ";</sup></span></td>\n    </tr>\n    <tr>\n      <td>Disease / Disorder<span class=\"DIS\"><sup>&#" + HtmlTextWriter.getSemanticSymbol(SemanticGroup.DISORDER.getCode()) + ";</sup></span></td>\n      <td>Medication<span class=\"DRG\"><sup>&#" + HtmlTextWriter.getSemanticSymbol(SemanticGroup.MEDICATION.getCode()) + ";</sup></span></td>\n    </tr>\n    <tr>\n      <td>Anatomical Site<span class=\"ANT\"><sup>&#" + HtmlTextWriter.getSemanticSymbol(SemanticGroup.ANATOMICAL_SITE.getCode()) + ";</sup></span></td>\n    </tr>\n  </table>\n  <hr>\n  <table>\n    <tr>\n      <td>Coreference Element<span class=\"ENT\"><sup>1</sup></span></td>\n    </tr>\n  </table>\n</div>\n";
    }

    private static String endBody() {
        return "</body>\n</html>\n";
    }

    private static class TextSpanComparator
    implements Comparator<TextSpan> {
        private TextSpanComparator() {
        }

        @Override
        public int compare(TextSpan t1, TextSpan t2) {
            int r = t1.getBegin() - t2.getBegin();
            if (r != 0) {
                return r;
            }
            return t1.getEnd() - t2.getEnd();
        }
    }
}

