/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.ctakes.core.cc.pretty.SemanticGroup;
import org.apache.log4j.Logger;

final class JsWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"JsWriter");

    private JsWriter() {
    }

    static void writeJsFile(String filePath) {
        File outputFile = new File(filePath);
        outputFile.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.write(JsWriter.getSwapInfoScript());
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Could not not write js file " + outputFile.getPath()));
            LOGGER.error((Object)ioE.getMessage());
        }
    }

    private static String getSwapInfoScript() {
        return "  function iaf(txt) {\n    var aff=txt.replace( /AFF_/g,\"<br><h3>Affirmed</h3>\" );\n    var neg=aff.replace( /NEG_/g,\"<br><h3>Negated</h3>\" );\n    var unc=neg.replace( /UNC_/g,\"<br><h3>Uncertain</h3>\" );\n    var unn=unc.replace( /UNN_/g,\"<br><h3>Uncertain, Negated</h3>\" );\n    var gnr=unn.replace( /GNR_/g,\"\" );\n    var wik1=gnr.replace( /WIK_/g,\"<a href=\\\"https://vsearch.nlm.nih.gov/vivisimo/cgi-bin/query-meta?v%3Aproject=medlineplus&v%3Asources=medlineplus-bundle&query=\" );\n    var wik2=wik1.replace( /_WK_/g,\"\\\" target=\\\"_blank\\\">\" );\n    var wik3=wik2.replace( /_WIK/g,\"</a>\" );\n    var ant=wik3.replace( /" + SemanticGroup.ANATOMICAL_SITE.getCode() + "/g,\"<b>Anatomical Site</b>\" );\n    var dis=ant.replace( /" + SemanticGroup.DISORDER.getCode() + "/g,\"<b>Disease/ Disorder</b>\" );\n    var fnd=dis.replace( /" + SemanticGroup.FINDING.getCode() + "/g,\"<b>Sign/ Symptom</b>\" );\n    var prc=fnd.replace( /" + SemanticGroup.PROCEDURE.getCode() + "/g,\"<b>Procedure</b>\" );\n    var drg=prc.replace( /" + SemanticGroup.MEDICATION.getCode() + "/g,\"<b>Medication</b>\" );\n    var evt=drg.replace( /" + "EVT" + "/g,\"<b>Event</b>\" );\n    var tmx=evt.replace( /" + "TMX" + "/g,\"<b>Time</b>\" );\n    var unk=tmx.replace( /" + "UNK" + "/g,\"<b>Unknown</b>\" );\n    var spc=unk.replace( /" + "SPC_" + "/g,\"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\" );\n    var prf1=spc.replace( /\\[/g,\"<i>\" );\n    var prf2=prf1.replace( /\\]/g,\"</i>\" );\n    var nl=prf2.replace( /" + "NL_" + "/g,\"<br>\" );\n    document.getElementById(\"ia\").innerHTML = nl;\n  }\n";
    }
}

