/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.plaintext;

import java.io.IOException;
import org.apache.ctakes.core.cc.AbstractJCasFileWriter;
import org.apache.ctakes.core.cc.pretty.plaintext.PrettyTextWriter;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.uima.UimaContext;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Pretty Text Writer", description="Writes text files with document text and simple markups (POS, Semantic Group, CUI, Negation).", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN}, usables={PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX, PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public final class PrettyTextWriterFit
extends AbstractJCasFileWriter {
    private final PrettyTextWriter _prettyTextWriter = new PrettyTextWriter();

    @Override
    public void writeFile(JCas jCas, String outputDir, String documentId, String fileName) throws IOException {
        this._prettyTextWriter.writeFile(jCas, outputDir + "/" + documentId + ".pretty.txt");
    }

    @Override
    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        try {
            this._prettyTextWriter.setOutputDirectory((String)uimaContext.getConfigParameterValue("OutputDirectory"));
        }
        catch (IllegalArgumentException | SecurityException multE) {
            throw new ResourceInitializationException((Throwable)multE);
        }
    }
}

