/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.property.plaintext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.cc.pretty.SemanticGroup;
import org.apache.ctakes.core.util.annotation.OntologyConceptUtil;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.typesystem.type.refsem.Attribute;
import org.apache.ctakes.typesystem.type.refsem.BodyLaterality;
import org.apache.ctakes.typesystem.type.refsem.BodySide;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.BodyLateralityModifier;
import org.apache.ctakes.typesystem.type.textsem.BodySideModifier;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class PropertyTextWriter {
    private static final Logger LOGGER = Logger.getLogger((String)"PropertyTextWriter");
    private static final String FILE_EXTENSION = ".properties.txt";
    private String _outputDirPath;

    public void setOutputDirectory(String outputDirectoryPath) throws IllegalArgumentException, SecurityException {
        if (outputDirectoryPath == null || outputDirectoryPath.isEmpty()) {
            this._outputDirPath = "";
            LOGGER.debug((Object)("No Output Directory Path specified, using current working directory " + System.getProperty("user.dir")));
            return;
        }
        File outputDir = new File(outputDirectoryPath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException(outputDirectoryPath + " is not a valid directory path");
        }
        this._outputDirPath = outputDirectoryPath;
        LOGGER.debug((Object)("Output Directory Path set to " + this._outputDirPath));
    }

    public void process(JCas jcas) {
        LOGGER.info((Object)"Starting processing");
        String docId = DocIdUtil.getDocumentIdForFile(jcas);
        File outputFile = this._outputDirPath == null || this._outputDirPath.isEmpty() ? new File(docId + FILE_EXTENSION) : new File(this._outputDirPath, docId + FILE_EXTENSION);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            Collection sentences = JCasUtil.select((JCas)jcas, Sentence.class);
            for (Sentence sentence : sentences) {
                PropertyTextWriter.writeSentence(jcas, (AnnotationFS)sentence, writer);
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Could not not write pretty property file " + outputFile.getPath()));
            LOGGER.error((Object)ioE.getMessage());
        }
        LOGGER.info((Object)"Finished processing");
    }

    public static void writeSentence(JCas jcas, AnnotationFS sentence, BufferedWriter writer) throws IOException {
        String sentenceText = sentence.getCoveredText().trim();
        if (sentenceText.isEmpty()) {
            return;
        }
        List identifiedAnnotations = JCasUtil.selectCovered((JCas)jcas, IdentifiedAnnotation.class, (AnnotationFS)sentence);
        writer.write(sentenceText);
        writer.newLine();
        for (IdentifiedAnnotation annotation : identifiedAnnotations) {
            Map<String, Collection<UmlsConcept>> semanticConcepts = PropertyTextWriter.getSemanticConcepts(annotation);
            if (semanticConcepts.isEmpty()) continue;
            writer.write("\"" + annotation.getCoveredText() + "\"" + PropertyTextWriter.getAnnotationProperties(annotation));
            if (annotation instanceof EventMention) {
                writer.write(PropertyTextWriter.getEventProperties((EventMention)annotation));
            } else if (annotation instanceof AnatomicalSiteMention) {
                writer.write(PropertyTextWriter.getAnatomicalProperties((AnatomicalSiteMention)annotation));
            }
            writer.newLine();
            for (Map.Entry<String, Collection<UmlsConcept>> umlsConcepts : semanticConcepts.entrySet()) {
                writer.write(" \t" + umlsConcepts.getKey());
                writer.newLine();
                for (UmlsConcept umlsConcept : umlsConcepts.getValue()) {
                    String preferredText = umlsConcept.getPreferredText();
                    writer.write(" \t \t" + umlsConcept.getCui() + (preferredText != null ? " " + preferredText : ""));
                    writer.newLine();
                }
            }
            Collection<String> relations = PropertyTextWriter.getRelations(jcas, annotation);
            for (String relation : relations) {
                writer.write(" \t" + relation);
                writer.newLine();
            }
        }
        writer.newLine();
    }

    private static Map<String, Collection<UmlsConcept>> getSemanticConcepts(IdentifiedAnnotation identifiedAnnotation) {
        Collection<UmlsConcept> umlsConcepts = OntologyConceptUtil.getUmlsConcepts(identifiedAnnotation);
        if (umlsConcepts == null || umlsConcepts.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<UmlsConcept>> semanticConcepts = new HashMap<String, Collection<UmlsConcept>>();
        HashSet<String> usedCuis = new HashSet<String>();
        for (UmlsConcept umlsConcept : umlsConcepts) {
            if (usedCuis.contains(umlsConcept.getCui())) continue;
            usedCuis.add(umlsConcept.getCui());
            String semanticName = SemanticGroup.getSemanticName(identifiedAnnotation, umlsConcept);
            semanticConcepts.putIfAbsent(semanticName, new HashSet());
            ((Collection)semanticConcepts.get(semanticName)).add(umlsConcept);
        }
        return semanticConcepts;
    }

    private static String getAnnotationProperties(IdentifiedAnnotation annotation) {
        StringBuilder sb = new StringBuilder();
        if (annotation.getPolarity() < 0) {
            sb.append(" negated");
        }
        if (annotation.getUncertainty() == 1) {
            sb.append(" uncertain");
        }
        if (annotation.getGeneric()) {
            sb.append(" generic");
        }
        if (annotation.getConditional()) {
            sb.append(" conditional");
        }
        if (annotation.getHistoryOf() == 1) {
            sb.append(" in history");
        }
        if (annotation.getSubject() != null && !annotation.getSubject().isEmpty()) {
            sb.append(" for ").append(annotation.getSubject());
        }
        return sb.toString();
    }

    private static String getEventProperties(EventMention eventMention) {
        String permanence;
        String aspect;
        Event event = eventMention.getEvent();
        if (event == null) {
            return "";
        }
        EventProperties eventProperties = event.getProperties();
        if (eventProperties == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" occurred ");
        sb.append(eventProperties.getDocTimeRel().toLowerCase());
        sb.append(" document time");
        String modality = eventProperties.getContextualModality();
        if (modality != null && !modality.isEmpty()) {
            sb.append(", ");
            sb.append(modality.toLowerCase());
        }
        if ((aspect = eventProperties.getContextualAspect()) != null && !aspect.isEmpty()) {
            sb.append(", ");
            sb.append(aspect.toLowerCase());
        }
        if ((permanence = eventProperties.getPermanence()) != null && !permanence.isEmpty()) {
            sb.append(", ");
            sb.append(permanence.toLowerCase());
        }
        return sb.toString();
    }

    private static String getAnatomicalProperties(AnatomicalSiteMention anatomicalSite) {
        Attribute normalized;
        BodySideModifier bodySide;
        Attribute normalized2;
        StringBuilder sb = new StringBuilder();
        BodyLateralityModifier laterality = anatomicalSite.getBodyLaterality();
        if (laterality != null && (normalized2 = laterality.getNormalizedForm()) != null && normalized2 instanceof BodyLaterality) {
            sb.append(", ");
            sb.append(((BodyLaterality)normalized2).getValue());
        }
        if ((bodySide = anatomicalSite.getBodySide()) != null && (normalized = bodySide.getNormalizedForm()) != null && normalized instanceof BodySide) {
            sb.append(", ");
            sb.append(((BodySide)normalized).getValue());
        }
        return sb.toString();
    }

    private static Collection<String> getRelations(JCas jcas, IdentifiedAnnotation annotation) {
        Collection relations = JCasUtil.select((JCas)jcas, BinaryTextRelation.class);
        if (relations == null || relations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> relationTexts = new ArrayList<String>();
        for (BinaryTextRelation relation : relations) {
            Annotation argument1 = relation.getArg1().getArgument();
            Annotation argument2 = relation.getArg2().getArgument();
            if (!annotation.equals((Object)argument1) && !annotation.equals((Object)argument2)) continue;
            relationTexts.add(argument1.getCoveredText() + " " + relation.getCategory().toLowerCase() + " " + argument2.getCoveredText());
        }
        return relationTexts;
    }
}

