/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.concurrent;

import org.apache.ctakes.core.ae.SentenceDetector;
import org.apache.ctakes.core.concurrent.ThreadSafeWrapper;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Thread Safe Sentence Detector", description="Annotates Sentences based upon an OpenNLP model.", dependencies={PipeBitInfo.TypeProduct.SECTION}, products={PipeBitInfo.TypeProduct.SENTENCE})
public final class ThreadSafeSentenceDetector
extends SentenceDetector {
    private static final Logger LOGGER = Logger.getLogger((String)"ThreadedSentenceDetector");

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        SdSingleton.getInstance().initialize(context);
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        SdSingleton.getInstance().process(jCas);
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(ThreadSafeSentenceDetector.class, (Object[])new Object[0]);
    }

    private static enum SdSingleton implements ThreadSafeWrapper<SentenceDetector>
    {
        INSTANCE;

        private final SentenceDetector _delegate;
        private boolean _initialized;
        private final Object LOCK = new Object();

        public static SdSingleton getInstance() {
            return INSTANCE;
        }

        private SdSingleton() {
            this._delegate = new SentenceDetector();
        }

        @Override
        public Object getLock() {
            return this.LOCK;
        }

        @Override
        public SentenceDetector getDelegate() {
            return this._delegate;
        }

        @Override
        public boolean isInitialized() {
            return this._initialized;
        }

        @Override
        public void setInitialized(boolean initialized) {
            this._initialized = initialized;
        }
    }
}

