/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.ctakes.core.patient.PatientNoteStore;
import org.apache.ctakes.core.pipeline.ProgressManager;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.BannerWriter;
import org.apache.ctakes.core.util.NumberedSuffixComparator;
import org.apache.ctakes.core.util.doc.DocIdUtil;
import org.apache.ctakes.core.util.doc.JCasBuilder;
import org.apache.ctakes.core.util.doc.SourceMetadataUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.impl.CollectionReaderDescription_impl;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.ConfigurationParameterDeclarations_impl;
import org.apache.uima.resource.metadata.impl.ConfigurationParameterSettings_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public abstract class AbstractFileTreeReader
extends JCasCollectionReader_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"AbstractFileTreeReader");
    public static final String PARAM_WRITE_BANNER = "WriteBanner";
    @org.apache.uima.fit.descriptor.ConfigurationParameter(name="WriteBanner", description="Write a large banner at each major step of the pipeline.", mandatory=false, defaultValue={"no"})
    private String _writeBannerChoice;
    @org.apache.uima.fit.descriptor.ConfigurationParameter(name="InputDirectory", description="Directory for all input files.")
    private String _rootDirPath;
    public static final String PARAM_ENCODING = "Encoding";
    public static final String UNICODE = "unicode";
    @org.apache.uima.fit.descriptor.ConfigurationParameter(name="Encoding", description="The character encoding used by the input files.", mandatory=false)
    private String _encoding;
    public static final String PARAM_EXTENSIONS = "Extensions";
    @org.apache.uima.fit.descriptor.ConfigurationParameter(name="Extensions", description="The extensions of the files that the collection reader will read.", defaultValue={"*"}, mandatory=false)
    private String[] _explicitExtensions;
    public static final String PARAM_KEEP_CR = "KeepCR";
    @org.apache.uima.fit.descriptor.ConfigurationParameter(name="KeepCR", description="Keep windows-format carriage return characters at line endings.  This will only keep existing characters, it will not add them.", mandatory=false)
    private boolean _keepCrChar = true;
    public static final String CR_TO_SPACE = "CRtoSpace";
    @org.apache.uima.fit.descriptor.ConfigurationParameter(name="CRtoSpace", description="Change windows-format CR + LF character sequences to LF + <Space>.", mandatory=false)
    private boolean _crToSpace = false;
    public static final String PATIENT_LEVEL = "PatientLevel";
    @org.apache.uima.fit.descriptor.ConfigurationParameter(name="PatientLevel", description="The level in the directory hierarchy at which patient identifiers exist.Default value is 1; directly under root input directory.", mandatory=false)
    private int _patientLevel = 1;
    public static final String STRIP_QUOTES = "StripQuotes";
    @org.apache.uima.fit.descriptor.ConfigurationParameter(name="StripQuotes", description="Replace document-enclosing quote characters with space characters.", mandatory=false)
    private boolean _stripQuotes = false;
    protected static final String UNKNOWN = "Unknown";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final Pattern CR_LF = Pattern.compile("\\r\\n");
    private boolean _writeBanner;
    private File _rootDir;
    private Collection<String> _validExtensions;
    private List<File> _files;
    private Map<File, String> _filePatients;
    private Map<String, Integer> _patientDocCounts = new HashMap<String, Integer>();
    private int _currentIndex;
    private Comparator<File> _fileComparator;

    public AbstractFileTreeReader() {
        this.setMetaData(AbstractFileTreeReader.createMetaData());
    }

    protected abstract void readFile(JCas var1, File var2) throws IOException;

    protected Comparator<File> createFileComparator() {
        return new FileComparator();
    }

    public DateFormat getDateFormat() {
        return DATE_FORMAT;
    }

    protected List<File> getFiles() {
        return this._files;
    }

    protected int getCurrentIndex() {
        return this._currentIndex;
    }

    protected void setCurrentIndex(int index) {
        this._currentIndex = index;
    }

    protected String getPatientId(File file) {
        return this._filePatients.getOrDefault(file, "UnknownPatient");
    }

    public int getNoteCount() {
        if (this._files == null) {
            LOGGER.error((Object)"Not yet initialized");
            return 0;
        }
        return this._files.size();
    }

    protected File getRootDir() {
        if (this._rootDir == null) {
            LOGGER.error((Object)"Not yet initialized");
            return null;
        }
        return this._rootDir;
    }

    protected String getRootPath() {
        File rootDir = this.getRootDir();
        if (rootDir == null) {
            LOGGER.error((Object)"Not yet initialized");
            return UNKNOWN;
        }
        return rootDir.getAbsolutePath();
    }

    protected final String getValidEncoding() {
        if (this._rootDir == null) {
            LOGGER.error((Object)"Not yet initialized");
            return UNKNOWN;
        }
        if (this._encoding == null || this._encoding.isEmpty()) {
            return UNKNOWN;
        }
        return this._encoding;
    }

    protected Collection<String> getValidExtensions() {
        if (this._validExtensions == null) {
            LOGGER.error((Object)"Not yet initialized");
            return Collections.emptyList();
        }
        return this._validExtensions;
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        boolean bl = this._writeBanner = this._writeBannerChoice.equalsIgnoreCase("yes") || this._writeBannerChoice.equalsIgnoreCase("true");
        if (this._writeBanner) {
            BannerWriter.writeHello();
        }
        try {
            this._rootDir = FileLocator.getFile(this._rootDirPath);
        }
        catch (FileNotFoundException fnfE) {
            LOGGER.error((Object)("No Directory found at " + this._rootDirPath));
            throw new ResourceInitializationException((Throwable)fnfE);
        }
        this._validExtensions = AbstractFileTreeReader.createValidExtensions(this._explicitExtensions);
        this._currentIndex = 0;
        if (this._rootDir.isFile()) {
            String patient = this._rootDir.getParentFile().getName();
            this._files = Collections.singletonList(this._rootDir);
            this._filePatients = Collections.singletonMap(this._rootDir, patient);
            PatientNoteStore.getInstance().setWantedDocCount(patient, 1);
        } else {
            File[] children = this._rootDir.listFiles();
            if (children == null || children.length == 0) {
                this._filePatients = Collections.emptyMap();
                this._files = Collections.emptyList();
                return;
            }
            if (Arrays.stream(children).noneMatch(File::isDirectory)) {
                this._patientLevel = 0;
            }
            this._filePatients = new HashMap<File, String>();
            this._fileComparator = this.createFileComparator();
            this._files = this.getDescendentFiles(this._rootDir, this._validExtensions, 0);
            this._patientDocCounts.forEach((k, v) -> PatientNoteStore.getInstance().setWantedDocCount((String)k, (int)v));
        }
        ProgressManager.getInstance().initializeProgress(this._rootDirPath, this._files.size());
    }

    protected static Collection<String> createValidExtensions(String ... explicitExtensions) {
        if (explicitExtensions == null || explicitExtensions.length == 0) {
            return Collections.emptyList();
        }
        if (explicitExtensions.length == 1 && (explicitExtensions[0].equals("*") || explicitExtensions[0].equals(".*"))) {
            return Collections.emptyList();
        }
        ArrayList<String> validExtensions = new ArrayList<String>(explicitExtensions.length);
        for (String extension : explicitExtensions) {
            if (extension.startsWith(".")) {
                validExtensions.add(extension);
                continue;
            }
            validExtensions.add('.' + extension);
        }
        return validExtensions;
    }

    private List<File> getDescendentFiles(File parentDir, Collection<String> validExtensions, int level) {
        File[] children = parentDir.listFiles();
        if (children == null || children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> childDirs = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        for (File child : children) {
            if (child.isDirectory()) {
                childDirs.add(child);
                continue;
            }
            if (!AbstractFileTreeReader.isExtensionValid(child, validExtensions) || child.isHidden()) continue;
            files.add(child);
        }
        childDirs.sort(this._fileComparator);
        files.sort(this._fileComparator);
        ArrayList<File> descendentFiles = new ArrayList<File>(files);
        for (File childDir : childDirs) {
            descendentFiles.addAll(this.getDescendentFiles(childDir, validExtensions, level + 1));
        }
        if (level == this._patientLevel) {
            String patientId = parentDir.getName();
            int count = this._patientDocCounts.getOrDefault(patientId, 0);
            this._patientDocCounts.put(patientId, count + descendentFiles.size());
            descendentFiles.forEach(f -> this._filePatients.put((File)f, patientId));
        }
        return descendentFiles;
    }

    protected static boolean isExtensionValid(File file, Collection<String> validExtensions) {
        if (validExtensions.isEmpty()) {
            return true;
        }
        String fileName = file.getName();
        for (String extension : validExtensions) {
            if (!fileName.endsWith(extension)) continue;
            if (fileName.equals(extension)) {
                LOGGER.warn((Object)("File " + file.getPath() + " name exactly matches extension " + extension + " so it will not be read."));
                return false;
            }
            return true;
        }
        return false;
    }

    protected static String createDocumentID(File file, Collection<String> validExtensions) {
        String fileName = file.getName();
        String maxExtension = "";
        for (String extension : validExtensions) {
            if (!fileName.endsWith(extension) || extension.length() <= maxExtension.length()) continue;
            maxExtension = extension;
        }
        int lastDot = fileName.lastIndexOf(46);
        if (!maxExtension.isEmpty()) {
            lastDot = fileName.length() - maxExtension.length();
        }
        if (lastDot < 0) {
            return fileName;
        }
        return fileName.substring(0, lastDot);
    }

    protected String createDocumentIdPrefix(File file, File rootDir) {
        String rootPath;
        String parentPath = file.getParent();
        if (parentPath.equals(rootPath = rootDir.getPath()) || !parentPath.startsWith(rootPath)) {
            return "";
        }
        return parentPath.substring(rootPath.length() + 1);
    }

    protected String createDocumentType(String documentId) {
        int lastScore = documentId.lastIndexOf(95);
        if (lastScore < 0 || lastScore == documentId.length() - 1) {
            return "ClinicalNote";
        }
        return documentId.substring(lastScore + 1);
    }

    protected String createDocumentTime(File file) {
        long millis = file.lastModified();
        return this.getDateFormat().format(millis);
    }

    protected final boolean isKeepCrChar() {
        return this._keepCrChar;
    }

    protected final String handleTextEol(String text) {
        String docText = text;
        if (!this.isKeepCrChar() && !docText.isEmpty() && docText.contains("\r")) {
            LOGGER.debug((Object)"Removing Carriage-Return characters ...");
            docText = CR_LF.matcher(docText).replaceAll("\n");
        }
        if (!docText.isEmpty() && !docText.endsWith("\n")) {
            docText = docText + "\n";
        }
        return docText;
    }

    protected final String handleQuotedDoc(String text) {
        if (!this._stripQuotes || text.isEmpty()) {
            return text;
        }
        String docText = AbstractFileTreeReader.handleQuotedDoc(text, '\"');
        return AbstractFileTreeReader.handleQuotedDoc(docText, '\'');
    }

    private static String handleQuotedDoc(String text, char quote) {
        String docText = text.trim();
        int beginDocQuote = docText.indexOf(quote);
        if (beginDocQuote != 0) {
            return text;
        }
        int endDocQuote = docText.lastIndexOf(quote);
        if (endDocQuote != docText.length() - 1) {
            return text;
        }
        LOGGER.debug((Object)("Replacing document-enclosing quote characters " + quote + " ..."));
        String unquotedText = text;
        int beginQuote = text.indexOf(quote);
        unquotedText = beginQuote == 0 ? " " + unquotedText.substring(1) : unquotedText.substring(0, beginQuote) + " " + unquotedText.substring(beginQuote + 1);
        int endQuote = unquotedText.lastIndexOf(quote);
        unquotedText = endQuote == unquotedText.length() - 1 ? unquotedText.substring(0, unquotedText.length() - 1) + " " : unquotedText.substring(0, endQuote) + " " + unquotedText.substring(endQuote + 1);
        return unquotedText;
    }

    protected JCasBuilder getJCasBuilder(File file) {
        String id = AbstractFileTreeReader.createDocumentID(file, this.getValidExtensions());
        String idPrefix = this.createDocumentIdPrefix(file, this.getRootDir());
        String docType = this.createDocumentType(id);
        String docTime = this.createDocumentTime(file);
        String patientId = this.getPatientId(file);
        return new JCasBuilder().setDocId(id).setDocIdPrefix(idPrefix).setDocType(docType).setDocTime(docTime).setPatientId(patientId).setDocPath(file.getAbsolutePath()).nullDocText();
    }

    public boolean hasNext() {
        boolean hasNext;
        if (this._currentIndex == 0 && this._writeBanner) {
            BannerWriter.writeProcess();
        }
        boolean bl = hasNext = this._currentIndex < this._files.size();
        if (!hasNext) {
            ProgressManager.getInstance().updatePatientId("PROGRESS_COMPLETE");
            ProgressManager.getInstance().updateDocId("PROGRESS_COMPLETE");
            ProgressManager.getInstance().updateProgress(this._files.size());
            if (this._writeBanner) {
                BannerWriter.writeFinished();
            }
        }
        return hasNext;
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        File file = this._files.get(this._currentIndex);
        this.getJCasBuilder(file).populate(jcas);
        ProgressManager.getInstance().updatePatientId(SourceMetadataUtil.getPatientIdentifier(jcas));
        ProgressManager.getInstance().updateDocId(DocIdUtil.getDocumentID(jcas));
        ProgressManager.getInstance().updateProgress(this._currentIndex);
        ++this._currentIndex;
        this.readFile(jcas, file);
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this._currentIndex, this._files.size(), "entities")};
    }

    private static ResourceMetaData createMetaData() {
        ReaderMetadata metadata = new ReaderMetadata();
        metadata.setUUID("AFTR");
        metadata.setName("AbstractFileTreeReader");
        metadata.setVersion("1");
        metadata.setDescription("Abstract for reader of files in a directory tree");
        metadata.setVendor("ctakes");
        metadata.setCopyright("2017");
        return metadata;
    }

    private static class FileComparator
    implements Comparator<File> {
        private final Comparator<String> __delegate = new NumberedSuffixComparator();

        private FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            return this.__delegate.compare(file1.getName(), file2.getName());
        }
    }

    private static final class ReaderMetadata
    extends CollectionReaderDescription_impl
    implements ResourceMetaData {
        static final long serialVersionUID = 3408359518094534817L;
        private String mUUID;
        private String mName;
        private String mDescription;
        private String mVersion;
        private String mVendor;
        private String mCopyright;
        private ConfigurationParameterDeclarations mConfigurationParameterDeclarations = new ConfigurationParameterDeclarations_impl();
        private ConfigurationParameterSettings mConfigurationParameterSettings = new ConfigurationParameterSettings_impl();
        private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("resourceMetaData", new PropertyXmlInfo[]{new PropertyXmlInfo("name", false), new PropertyXmlInfo("description"), new PropertyXmlInfo("version"), new PropertyXmlInfo("vendor"), new PropertyXmlInfo("copyright"), new PropertyXmlInfo("configurationParameterDeclarations", (String)null), new PropertyXmlInfo("configurationParameterSettings", (String)null)});

        private ReaderMetadata() {
        }

        public void resolveImports() throws InvalidXMLException {
        }

        public void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
        }

        public String getUUID() {
            return this.mUUID;
        }

        public void setUUID(String aUUID) {
            this.mUUID = aUUID;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String aName) {
            this.mName = aName;
        }

        public String getVersion() {
            return this.mVersion;
        }

        public void setVersion(String aVersion) {
            this.mVersion = aVersion;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public void setDescription(String aDescription) {
            this.mDescription = aDescription;
        }

        public String getVendor() {
            return this.mVendor;
        }

        public void setVendor(String aVendor) {
            this.mVendor = aVendor;
        }

        public String getCopyright() {
            return this.mCopyright;
        }

        public void setCopyright(String aCopyright) {
            this.mCopyright = aCopyright;
        }

        public ConfigurationParameterSettings getConfigurationParameterSettings() {
            return this.mConfigurationParameterSettings;
        }

        public void setConfigurationParameterSettings(ConfigurationParameterSettings aSettings) {
            this.mConfigurationParameterSettings = aSettings;
        }

        public ConfigurationParameterDeclarations getConfigurationParameterDeclarations() {
            return this.mConfigurationParameterDeclarations;
        }

        public void setConfigurationParameterDeclarations(ConfigurationParameterDeclarations aDeclarations) {
            this.mConfigurationParameterDeclarations = aDeclarations;
        }

        public void validateConfigurationParameterSettings() throws ResourceConfigurationException {
            ConfigurationParameterDeclarations cfgParamDecls = this.getConfigurationParameterDeclarations();
            ConfigurationParameterSettings cfgParamSettings = this.getConfigurationParameterSettings();
            NameValuePair[] nvps = cfgParamSettings.getParameterSettings();
            if (nvps.length > 0) {
                this.validateConfigurationParameterSettings(nvps, null, cfgParamDecls);
            } else {
                Map settingsForGroups = cfgParamSettings.getSettingsForGroups();
                Set entrySet = settingsForGroups.entrySet();
                for (Map.Entry entry : entrySet) {
                    String groupName = (String)entry.getKey();
                    nvps = (NameValuePair[])entry.getValue();
                    if (nvps == null) continue;
                    this.validateConfigurationParameterSettings(nvps, groupName, cfgParamDecls);
                }
            }
        }

        protected void validateConfigurationParameterSettings(NameValuePair[] aNVPs, String aGroupName, ConfigurationParameterDeclarations aParamDecls) throws ResourceConfigurationException {
            for (int i = 0; i < aNVPs.length; ++i) {
                String name = aNVPs[i].getName();
                ConfigurationParameter param = aParamDecls.getConfigurationParameter(aGroupName, name);
                if (param == null) {
                    if (aGroupName == null) {
                        throw new ResourceConfigurationException("nonexistent_parameter", new Object[]{name, this.getName()});
                    }
                    throw new ResourceConfigurationException("nonexistent_parameter_in_group", new Object[]{name, aGroupName, this.getName()});
                }
                this.validateConfigurationParameterDataTypeMatch(param, aNVPs[i]);
            }
        }

        protected void validateConfigurationParameterDataTypeMatch(ConfigurationParameter aParam, NameValuePair aNVP) throws ResourceConfigurationException {
            String paramName = aParam.getName();
            String paramType = aParam.getType();
            Class<?> valClass = aNVP.getValue().getClass();
            if (aParam.isMultiValued()) {
                if (!valClass.isArray()) {
                    throw new ResourceConfigurationException("array_required", new Object[]{paramName, this.getName()});
                }
                valClass = valClass.getComponentType();
                if (Array.getLength(aNVP.getValue()) == 0 && valClass.equals(Object.class)) {
                    aNVP.setValue(Array.newInstance(this.getClassForParameterType(paramType), 0));
                    return;
                }
            }
            if (valClass != this.getClassForParameterType(paramType)) {
                throw new ResourceConfigurationException("parameter_type_mismatch", new Object[]{this.getName(), valClass.getName(), paramName, paramType});
            }
        }

        protected Class getClassForParameterType(String paramType) {
            return "String".equals(paramType) ? String.class : ("Boolean".equals(paramType) ? Boolean.class : ("Integer".equals(paramType) ? Integer.class : ("Float".equals(paramType) ? Float.class : null)));
        }
    }
}

