/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ctakes.core.cr.AbstractFileTreeReader;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.log4j.Logger;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="File Tree Reader", description="Reads document texts from text files in a directory tree.", role=PipeBitInfo.Role.READER, products={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX})
public final class FileTreeReader
extends AbstractFileTreeReader {
    private static final Logger LOGGER = Logger.getLogger((String)"FileTreeReader");

    @Override
    protected void readFile(JCas jCas, File file) throws IOException {
        String docText = this.readFile(file);
        docText = this.handleQuotedDoc(docText);
        docText = this.handleTextEol(docText);
        jCas.setDocumentText(docText);
    }

    public String readFile(File file) throws IOException {
        LOGGER.info((Object)("Reading " + file.getPath() + " ..."));
        if (!this.isKeepCrChar()) {
            try {
                return this.readByPath(file);
            }
            catch (IOException ioE) {
                LOGGER.warn((Object)("Bad characters in " + file.getPath()));
            }
        }
        try {
            return this.readByStreamReader(file);
        }
        catch (IOException iOException) {
            return this.readByBuffer(file);
        }
    }

    private String readByPath(File file) throws IOException {
        String encoding = this.getValidEncoding();
        if (encoding != null && !encoding.isEmpty() && !"Unknown".equals(encoding)) {
            Charset charset = Charset.forName(encoding);
            try (Stream<String> stream = Files.lines(file.toPath(), charset);){
                String string = stream.collect(Collectors.joining("\n"));
                return string;
            }
        }
        return FileTreeReader.safeReadByPath(file);
    }

    private static String safeReadByPath(File file) throws IOException {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.IGNORE);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), decoder));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private String readByBuffer(File file) throws IOException {
        String encoding = this.getValidEncoding();
        byte[] buffer = new byte[8192];
        StringBuilder sb = new StringBuilder();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file), buffer.length);){
            int length;
            while ((length = ((InputStream)inputStream).read(buffer)) >= 0) {
                if (encoding != null && !encoding.isEmpty() && !"Unknown".equals(encoding)) {
                    sb.append(new String(buffer, 0, length, encoding));
                    continue;
                }
                sb.append(new String(buffer, 0, length));
            }
        }
        catch (FileNotFoundException fnfE) {
            throw new IOException(fnfE);
        }
        return sb.toString();
    }

    private String readByStreamReader(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.IGNORE);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), decoder));){
            int i = reader.read();
            while (i != -1) {
                sb.append(Character.toChars(i));
                i = reader.read();
            }
        }
        catch (FileNotFoundException fnfE) {
            throw new IOException(fnfE);
        }
        return sb.toString();
    }

    public static CollectionReader createReader(String inputDirectory) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader(FileTreeReader.class, (Object[])new Object[]{"InputDirectory", inputDirectory});
    }
}

